/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.goat;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import com.mclegoman.perspective.client.entity.states.PerspectiveGoatRenderState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10030;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

@Mixin(priority = 100, value = net.minecraft.class_6256.class)
public class GoatEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/GoatEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10030 goatEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		if (goatEntityRenderState != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(goatEntityRenderState);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							if (variants.has("normal")) {
								JsonObject normal = class_3518.method_15296(variants, "normal");
								if (normal != null) isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(normal, "enabled", true));
							}
							if (variants.has("screaming")) {
								JsonObject screaming = class_3518.method_15296(variants, "screaming");
								if (screaming != null)
									isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(screaming, "enabled", true));
							}
						}
					}
				}
				if (isTexturedEntity) {
					String variant = ((PerspectiveGoatRenderState)goatEntityRenderState).perspective$getScreaming() ? "_screaming" : "";
					cir.setReturnValue(TexturedEntity.getTexture(goatEntityRenderState, "", variant, cir.getReturnValue()));
				}
			}
		}
	}
}