/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.horse;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_10033;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5148;
import net.minecraft.class_5167;

@Mixin(priority = 100, value = class_5167.class)
public class HorseMarkingFeatureRendererMixin {
	@Shadow @Final private static Map<class_5148, class_2960> TEXTURES;
	@Unique private class_10033 state;
	@Inject(method = "<init>", at = @At("RETURN"))
	private void perspective$init(class_3883 featureRendererContext, CallbackInfo ci) {
		TEXTURES.remove(class_5148.field_23808, null);
		TEXTURES.putIfAbsent(class_5148.field_23808, class_2960.method_60654("textures/entity/horse/horse_markings_none.png"));
	}
	@Inject(method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/HorseEntityRenderState;FF)V", at = @At(value = "HEAD"))
	public void perspective$render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_10033 horseEntityRenderState, float f, float g, CallbackInfo ci) {
		state = horseEntityRenderState;
	}
	@ModifyExpressionValue(method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/HorseEntityRenderState;FF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/RenderLayer;getEntityTranslucent(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"))
	private class_1921 perspective$getEntityTranslucent(class_1921 renderLayer) {
		return class_1921.method_23580(TexturedEntity.getTexture(state, "", perspective$getHorseMarking(state.field_53401), TEXTURES.get(state.field_53401)));
	}
	@Unique
	private String perspective$getHorseMarking(class_5148 marking) {
		if (marking.equals(class_5148.field_23809)) return "_markings_white";
		else if (marking.equals(class_5148.field_23810)) return "_markings_whitefield";
		else if (marking.equals(class_5148.field_23811)) return "_markings_whitedots";
		else if (marking.equals(class_5148.field_23812)) return "_markings_blackdots";
		else return "_markings_none";
	}
}