/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.iron_golem;

import com.google.common.collect.ImmutableMap;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_10037;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4691;
import net.minecraft.class_9273;

@Mixin(priority = 100, value = class_4691.class)
public class IronGolemCrackFeatureRendererMixin {
	@Mutable
	@Shadow @Final private static Map<class_9273.class_4621, class_2960> CRACK_TEXTURES;
	@Inject(at = @At("HEAD"), method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/IronGolemEntityRenderState;FF)V")
	private void perspective$render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_10037 ironGolemEntityRenderState, float f, float g, CallbackInfo ci) {
		if (ironGolemEntityRenderState != null) {
			CRACK_TEXTURES = ImmutableMap.of(
					class_9273.class_4621.field_21082, TexturedEntity.getTexture(ironGolemEntityRenderState, "", "_crackiness_low", class_2960.method_60654("textures/entity/iron_golem/iron_golem_crackiness_low.png")),
					class_9273.class_4621.field_21083, TexturedEntity.getTexture(ironGolemEntityRenderState, "", "_crackiness_medium", class_2960.method_60654("textures/entity/iron_golem/iron_golem_crackiness_medium.png")),
					class_9273.class_4621.field_21084, TexturedEntity.getTexture(ironGolemEntityRenderState, "", "_crackiness_high", class_2960.method_60654("textures/entity/iron_golem/iron_golem_crackiness_high.png"))
			);
		}
	}
}