/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.mooshroom;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import com.mclegoman.perspective.client.entity.renderer.feature.CowOverlayFeatureRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10047;
import net.minecraft.class_1438;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_560;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_926;
import net.minecraft.class_927;

@Mixin(priority = 100, value = class_926.class)
public abstract class MooshroomEntityRendererMixin extends class_927<class_1438, class_10047, class_560> {
	@Shadow @Final
	private static Map<class_1438.class_4053, class_2960> TEXTURES;
	public MooshroomEntityRendererMixin(class_5617.class_5618 context, class_560 entityModel, float f) {
		super(context, entityModel, f);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new CowOverlayFeatureRenderer<>(this, new class_560(context.method_32167(EntityModels.mooshroomOverlay)), new class_560(context.method_32167(EntityModels.babyMooshroomOverlay))));
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655("perspective", "textures/entity/minecraft/mooshroom/mooshroom_cape.png")).offsetZ(-0.50125F).offsetY(0.125F).rotation(class_7833.field_40714.rotationDegrees(90.0F)).build());
	}
	@Inject(method = "getTexture(Lnet/minecraft/client/render/entity/state/MooshroomEntityRenderState;)Lnet/minecraft/util/Identifier;", at = @At("RETURN"), cancellable = true)
	public void perspective$getTexture(class_10047 entity, CallbackInfoReturnable<class_2960> cir) {
		boolean isTexturedEntity = true;
		Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(entity);
		if (entityData.isPresent()) {
			JsonObject entitySpecific = entityData.get().getEntitySpecific();
			if (entitySpecific != null) {
				if (entitySpecific.has("variants")) {
					JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
					if (variants != null) {
						if (entitySpecific.has(entity.field_53493.method_15434().toLowerCase())) {
							JsonObject typeRegistry = class_3518.method_15296(variants, entity.field_53493.method_15434().toLowerCase());
							if (typeRegistry != null) {
								isTexturedEntity = class_3518.method_15258(typeRegistry, "enabled", true);
							}
						}
					}
				}
			}
			if (isTexturedEntity) {
				String variant = entity.field_53493 != null ? entity.field_53493.method_15434().toLowerCase() + "_" : "";
				cir.setReturnValue(TexturedEntity.getTexture(entity, variant, "", TEXTURES.get(entity.field_53493)));
			}
		}
	}
}