/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.mooshroom;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import net.minecraft.class_10047;
import net.minecraft.class_1438;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7923;
import net.minecraft.class_991;

@Mixin(priority = 100, value = class_991.class)
public class MooshroomMushroomFeatureRendererMixin {
	@Redirect(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/passive/MooshroomEntity$Type;getMushroomState()Lnet/minecraft/block/BlockState;"), method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/MooshroomEntityRenderState;FF)V")
	private class_2680 perspective$getMushroom(class_1438.class_4053 mooshroomType) {
		try {
			if (this.state != null) {
				Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(this.state);
				if (entityData.isPresent()) {
					JsonObject entitySpecific = entityData.get().getEntitySpecific();
					if (entitySpecific != null) {
						if (entitySpecific.has("variants")) {
							JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
							if (variants != null) {
								if (variants.has(mooshroomType.method_15434().toLowerCase())) {
									JsonObject typeRegistry = class_3518.method_15296(variants, mooshroomType.method_15434().toLowerCase());
									if (typeRegistry != null) {
										boolean enabled = class_3518.method_15258(typeRegistry, "enabled", true);
										if (enabled) {
											if (typeRegistry.has("block") || typeRegistry.has("mushroom")) {
												JsonObject block = typeRegistry.has("block") ? class_3518.method_15296(typeRegistry, "block") : class_3518.method_15296(typeRegistry, "mushroom");
												if (block.has("identifier")) {
													class_2960 blockId = IdentifierHelper.identifierFromString(class_3518.method_15253(block, "identifier", IdentifierHelper.stringFromIdentifier(class_7923.field_41175.method_10221(mooshroomType.method_18437().method_26204()))));
													if (class_7923.field_41175.method_10250(blockId)) return class_7923.field_41175.method_63535(blockId).method_9564();
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		} catch (Exception ignored) {}
		return mooshroomType.method_18437();
	}
	@Inject(at = @At("HEAD"), method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/MooshroomEntityRenderState;FF)V")
	private void perspective$getEntity(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_10047 mooshroomEntityRenderState, float f, float g, CallbackInfo ci) {
		this.state = mooshroomEntityRenderState;
	}
	@Unique
	private class_10047 state;
}