/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.panda;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10050;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_931;

@Mixin(priority = 100, value = class_931.class)
public class PandaEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/PandaEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10050 pandaEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		if (pandaEntityRenderState != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(pandaEntityRenderState);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15281(entitySpecific, "variants", new JsonObject());
						if (variants.has(pandaEntityRenderState.field_53499.method_15434().toLowerCase())) {
							JsonObject typeRegistry = class_3518.method_15281(variants, pandaEntityRenderState.field_53499.method_15434().toLowerCase(), new JsonObject());
							isTexturedEntity = class_3518.method_15258(typeRegistry, "enabled", true);
						}
					}
				}
			}
			if (isTexturedEntity) {
				String variant = pandaEntityRenderState.field_53499.method_15434() != null ? "_" + pandaEntityRenderState.field_53499.method_15434().toLowerCase() : "";
				cir.setReturnValue(TexturedEntity.getTexture(pandaEntityRenderState, "", variant, cir.getReturnValue()));
			}
		}
	}
}