/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.pig;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.MuddyFlowerModel;
import com.mclegoman.perspective.client.entity.renderer.feature.MuddyFlowerFeatureRenderer;
import com.mclegoman.perspective.client.entity.renderer.feature.OverlayFeatureRenderer;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_10042;
import net.minecraft.class_10053;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_587;
import net.minecraft.class_927;
import net.minecraft.class_932;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_932.class)
public abstract class PigEntityRendererMixin<T extends class_1308, S extends class_10042, M extends class_583<? super S>> extends class_927<T, S, M> {
	public PigEntityRendererMixin(class_5617.class_5618 context, M entityModel, float f) {
		super(context, entityModel, f);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new MuddyFlowerFeatureRenderer(this, new MuddyFlowerModel<>(context.method_32167(EntityModels.pigMuddyFlower)), class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/pig/muddy_flower.png")));
		this.method_4046(new OverlayFeatureRenderer(this, new class_587(context.method_32167(EntityModels.pigOverlay)), new class_587(context.method_32167(EntityModels.babyPigOverlay)), class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/pig/pig_overlay.png")));
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/PigEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10053 renderState, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(renderState, cir.getReturnValue()));
	}
}