/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.piglin;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import net.minecraft.class_10054;
import net.minecraft.class_2960;
import net.minecraft.class_4840;
import net.minecraft.class_4842;
import net.minecraft.class_5418;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_909;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_4842.class)
public abstract class PiglinEntityRendererMixin extends class_909<class_5418, class_10054, class_4840> {
	public PiglinEntityRendererMixin(class_5617.class_5618 context, class_4840 model, float shadowRadius) {
		super(context, model, shadowRadius);
	}
	@Inject(method = "<init>", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, class_5601 mainLayer, class_5601 babyMainLayer, class_5601 armorInnerLayer, class_5601 armorOuterLayer, class_5601 babyArmorInnerLayer, class_5601 babyArmorOuterLayer, CallbackInfo ci) {
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655("perspective", "textures/entity/minecraft/piglin/piglin_cape.png")).build());
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/PiglinEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10054 entity, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(entity, cir.getReturnValue()));
	}
}