/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.polar_bear;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import net.minecraft.class_10057;
import net.minecraft.class_2960;
import net.minecraft.class_937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_937.class)
public class PolarBearEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/PolarBearEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10057 polarBearEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(polarBearEntityRenderState, cir.getReturnValue()));
	}
}