/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.shulker;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10065;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_943;

@Mixin(priority = 100, value = class_943.class)
public class ShulkerEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/ShulkerEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10065 shulkerEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		if (shulkerEntityRenderState != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(shulkerEntityRenderState);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							if (shulkerEntityRenderState.field_53567 != null) {
								if (variants.has(shulkerEntityRenderState.field_53567.method_7792())) {
									JsonObject color = class_3518.method_15296(variants, shulkerEntityRenderState.field_53567.method_7792());
									if (color != null) isTexturedEntity = class_3518.method_15258(color, "enabled", true);
								}
							} else {
								if (variants.has("normal")) {
									JsonObject normal = class_3518.method_15296(variants, "normal");
									if (normal != null) isTexturedEntity = class_3518.method_15258(normal, "enabled", true);
								}
							}
						}
					}
				}
				if (isTexturedEntity) {
					String variant = shulkerEntityRenderState.field_53567 != null ? "_" + shulkerEntityRenderState.field_53567.method_7792() : "";
					cir.setReturnValue(TexturedEntity.getTexture(shulkerEntityRenderState, "", variant, cir.getReturnValue()));
				}
			}
		}
	}
}