/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.shulker_bullet;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import net.minecraft.class_10064;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_603;
import net.minecraft.class_940;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_940.class)
public class ShulkerBulletEntityRendererMixin {
	@Shadow @Final private static class_2960 TEXTURE;
	@Shadow @Final private class_603 model;
	@Inject(at = @At("HEAD"), method = "render(Lnet/minecraft/client/render/entity/state/ShulkerBulletEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V")
	private void perspective$getState(class_10064 shulkerBulletEntityRenderState, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
		this.state = shulkerBulletEntityRenderState;
	}
	@Redirect(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;", ordinal = 0), method = "render(Lnet/minecraft/client/render/entity/state/ShulkerBulletEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V")
	private class_4588 perspective$replaceTexture(class_4597 vertexConsumerProvider, class_1921 renderLayer) {
		return vertexConsumerProvider.getBuffer(this.state != null ? this.model.method_23500(TexturedEntity.getTexture(this.state, TEXTURE)) : renderLayer);
	}
	@Redirect(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;", ordinal = 1), method = "render(Lnet/minecraft/client/render/entity/state/ShulkerBulletEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V")
	private class_4588 perspective$replaceTexture2(class_4597 vertexConsumerProvider, class_1921 renderLayer) {
		return vertexConsumerProvider.getBuffer(this.state != null ? class_1921.method_23580(TexturedEntity.getTexture(this.state, TEXTURE)) : renderLayer);
	}
	@Unique private class_10064 state;
}