/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.skeleton;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.states.PerspectiveRenderState;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_1002;
import net.minecraft.class_10066;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_1002.class)
public class SkeletonOverlayFeatureRendererMixin<S extends class_10066> {
	@Mutable @Shadow @Final private class_2960 texture;
	@Inject(at = @At("HEAD"), method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/SkeletonEntityRenderState;FF)V")
	private void perspective$getTexture(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, S skeletonEntityRenderState, float f, float g, CallbackInfo ci) {
		class_2960 entityType = class_7923.field_41177.method_10221(((PerspectiveRenderState) skeletonEntityRenderState).perspective$getType());
		class_2960 defaultTexture = (entityType.equals(class_2960.method_60656("stray")) || entityType.equals(class_2960.method_60656("bogged"))) ? class_2960.method_60655(entityType.method_12836(), "textures/entity/skeleton/" + entityType.method_12832() + "_overlay.png") : class_2960.method_60655(Data.getVersion().getID(), "textures/entity/" + entityType.method_12836() + "/skeleton/" + entityType.method_12832() + "_overlay.png");
		texture = TexturedEntity.getTexture(skeletonEntityRenderState, "", "_overlay", defaultTexture);
	}
}