/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.stray;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import net.minecraft.class_10066;
import net.minecraft.class_1627;
import net.minecraft.class_2960;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_950;
import net.minecraft.class_9989;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_950.class)
public abstract class StrayEntityRendererMixin extends class_9989<class_1627, class_10066> {
	public StrayEntityRendererMixin(class_5617.class_5618 context, class_5601 layer, class_5601 armorInnerLayer, class_5601 armorOuterLayer) {
		super(context, layer, armorInnerLayer, armorOuterLayer);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655("perspective", "textures/entity/minecraft/skeleton/stray_cape.png")).build());
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/SkeletonEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10066 entity, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(entity, cir.getReturnValue()));
	}
}