/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.strider;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10070;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4999;

@Mixin(priority = 100, value = class_4999.class)
public class StriderEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/StriderEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10070 striderEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		if (striderEntityRenderState != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(striderEntityRenderState);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							if (variants.has("normal")) {
								JsonObject normal = class_3518.method_15296(variants, "normal");
								if (normal != null) isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(normal, "enabled", true));
							}
							if (variants.has("cold")) {
								JsonObject cold = class_3518.method_15296(variants, "cold");
								if (cold != null)
									isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(cold, "enabled", true));
							}
						}
					}
				}
				if (isTexturedEntity) {
					String variant = striderEntityRenderState.field_53586 ? "_cold" : "";
					cir.setReturnValue(TexturedEntity.getTexture(striderEntityRenderState, "", variant, cir.getReturnValue()));
				}
			}
		}
	}
}