/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.tropical_fish;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import net.minecraft.class_1001;
import net.minecraft.class_10076;
import net.minecraft.class_1474;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_1001.class)
public class TropicalFishColorFeatureRendererMixin {
	@Mutable @Shadow @Final private static class_2960 KOB_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 SUNSTREAK_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 SNOOPER_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 DASHER_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 BRINELY_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 SPOTTY_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 FLOPPER_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 STRIPEY_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 GLITTER_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 BLOCKFISH_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 BETTY_TEXTURE;
	@Mutable @Shadow @Final private static class_2960 CLAYFISH_TEXTURE;
	@Inject(method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/TropicalFishEntityRenderState;FF)V", at = @At("RETURN"))
	private void perspective$render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_10076 state, float f, float g, CallbackInfo ci) {
		// TODO: Add entity specific.
		if (state.field_53598.equals(class_1474.class_1475.field_6881))
			KOB_TEXTURE = TexturedEntity.getTexture(state, "", "_kob", class_2960.method_60654("textures/entity/fish/tropical_a_pattern_1.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6880))
			SUNSTREAK_TEXTURE = TexturedEntity.getTexture(state, "", "_sunstreak", class_2960.method_60654("textures/entity/fish/tropical_a_pattern_2.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6882))
			SNOOPER_TEXTURE = TexturedEntity.getTexture(state, "", "_snooper", class_2960.method_60654("textures/entity/fish/tropical_a_pattern_3.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6890))
			DASHER_TEXTURE = TexturedEntity.getTexture(state, "", "_dasher", class_2960.method_60654("textures/entity/fish/tropical_a_pattern_4.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6891))
			BRINELY_TEXTURE = TexturedEntity.getTexture(state, "", "_brinely", class_2960.method_60654("textures/entity/fish/tropical_a_pattern_5.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6892))
			SPOTTY_TEXTURE = TexturedEntity.getTexture(state, "", "_spotty", class_2960.method_60654("textures/entity/fish/tropical_a_pattern_6.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6893))
			FLOPPER_TEXTURE = TexturedEntity.getTexture(state, "", "_flopper", class_2960.method_60654("textures/entity/fish/tropical_b_pattern_1.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6887))
			STRIPEY_TEXTURE = TexturedEntity.getTexture(state, "", "_stripey", class_2960.method_60654("textures/entity/fish/tropical_b_pattern_2.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6883))
			GLITTER_TEXTURE = TexturedEntity.getTexture(state, "", "_glitter", class_2960.method_60654("textures/entity/fish/tropical_b_pattern_3.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6884))
			BLOCKFISH_TEXTURE = TexturedEntity.getTexture(state, "", "_blockfish", class_2960.method_60654("textures/entity/fish/tropical_b_pattern_4.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6888))
			BETTY_TEXTURE = TexturedEntity.getTexture(state, "", "_betty", class_2960.method_60654("textures/entity/fish/tropical_b_pattern_5.png"));
		else if (state.field_53598.equals(class_1474.class_1475.field_6889))
			CLAYFISH_TEXTURE = TexturedEntity.getTexture(state, "", "_clayfish", class_2960.method_60654("textures/entity/fish/tropical_b_pattern_6.png"));
	}
}