/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.tropical_fish;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import net.minecraft.class_10076;
import net.minecraft.class_2960;
import net.minecraft.class_959;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_959.class)
public class TropicalFishEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/TropicalFishEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10076 tropicalFishEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		// todo; add entity specific.
		// size, base color, & pattern color.
		cir.setReturnValue(TexturedEntity.getTexture(tropicalFishEntityRenderState, cir.getReturnValue()));
	}
}