/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.villager;

import com.google.gson.JsonObject;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10080;
import net.minecraft.class_1646;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5617;
import net.minecraft.class_620;
import net.minecraft.class_7923;
import net.minecraft.class_927;
import net.minecraft.class_963;

@Mixin(priority = 100, value = class_963.class)
public abstract class VillagerEntityRendererMixin extends class_927<class_1646, class_10080, class_620> {
	public VillagerEntityRendererMixin(class_5617.class_5618 context, class_620 entityModel, float f) {
		super(context, entityModel, f);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655("perspective", "textures/entity/minecraft/villager/villager_cape.png")).offsetZ(0.18F).offsetY(0.025F).build());
	}
	// TODO: Add textured entity to villager clothes and levels.
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/VillagerEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10080 entity, CallbackInfoReturnable<class_2960> cir) {
		if (entity != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(entity);
			if (entityData.isPresent()) {
				class_2960 variantId = class_7923.field_41194.method_10221(entity.method_62617().method_16919());
				String variant = variantId.toString().toLowerCase();
				class_2960 professionId = class_7923.field_41195.method_10221(entity.method_62617().method_16924());
				String profession = professionId.toString().toLowerCase();
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							if (entitySpecific.has(variant)) {
								JsonObject typeRegistry = class_3518.method_15296(variants, variant);
								if (typeRegistry != null) {
									isTexturedEntity = class_3518.method_15258(typeRegistry, "enabled", true);
								}
							}
						}
					}
					if (entitySpecific.has("professions")) {
						JsonObject professions = class_3518.method_15296(entitySpecific, "professions");
						if (professions != null) {
							if (entitySpecific.has(profession)) {
								JsonObject typeRegistry = class_3518.method_15296(professions, profession);
								if (typeRegistry != null) {
									isTexturedEntity = class_3518.method_15258(typeRegistry, "enabled", true);
								}
							}
						}
					}
				}
				if (isTexturedEntity) cir.setReturnValue(TexturedEntity.getTexture(entity, (entity.method_62617().method_16919() != null ? IdentifierHelper.getStringPart(IdentifierHelper.Type.NAMESPACE, variant) : ""), "", (entity.method_62617().method_16919() != null ? "_" + IdentifierHelper.getStringPart(IdentifierHelper.Type.KEY, variant) : ""), cir.getReturnValue()));
			}
		}
	}
}