/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.wandering_trader;

import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import net.minecraft.class_10080;
import net.minecraft.class_2960;
import net.minecraft.class_3989;
import net.minecraft.class_3992;
import net.minecraft.class_5617;
import net.minecraft.class_620;
import net.minecraft.class_927;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_3992.class)
public abstract class WanderingTraderEntityRendererMixin extends class_927<class_3989, class_10080, class_620> {
	public WanderingTraderEntityRendererMixin(class_5617.class_5618 context, class_620 entityModel, float f) {
		super(context, entityModel, f);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655("perspective", "textures/entity/minecraft/wandering_trader/wandering_trader_cape.png")).offsetZ(0.18F).offsetY(-0.025F).build());
	}
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/VillagerEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10080 entity, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(entity, cir.getReturnValue()));
	}
}