/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.warden;

import com.mclegoman.perspective.client.entity.TexturedEntity;
import net.minecraft.class_10081;
import net.minecraft.class_2960;
import net.minecraft.class_7287;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(priority = 100, value = class_7287.class)
public class WardenEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/WardenEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10081 wardenEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		cir.setReturnValue(TexturedEntity.getTexture(wardenEntityRenderState, cir.getReturnValue()));
	}
}