/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.wolf;

import com.google.gson.JsonObject;
import com.mclegoman.perspective.client.entity.TexturedEntity;
import com.mclegoman.luminance.common.util.IdentifierHelper;
import com.mclegoman.perspective.client.entity.TexturedEntityEntry;
import com.mclegoman.perspective.client.entity.states.PerspectiveTamedRenderState;
import com.mclegoman.perspective.client.entity.states.PerspectiveVariantRenderState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_10085;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_969;

@Mixin(priority = 100, value = class_969.class)
public class WolfEntityRendererMixin {
	@Inject(at = @At("RETURN"), method = "getTexture(Lnet/minecraft/client/render/entity/state/WolfEntityRenderState;)Lnet/minecraft/util/Identifier;", cancellable = true)
	private void perspective$getTexture(class_10085 wolfEntityRenderState, CallbackInfoReturnable<class_2960> cir) {
		if (wolfEntityRenderState != null) {
			boolean isTexturedEntity = true;
			Optional<TexturedEntityEntry> entityData = TexturedEntity.getEntity(wolfEntityRenderState);
			if (entityData.isPresent()) {
				JsonObject entitySpecific = entityData.get().getEntitySpecific();
				String variant = ((PerspectiveVariantRenderState)wolfEntityRenderState).perspective$getVariantId();
				if (entitySpecific != null) {
					if (entitySpecific.has("variants")) {
						JsonObject variants = class_3518.method_15296(entitySpecific, "variants");
						if (variants != null) {
							if (entitySpecific.has(variant.toLowerCase())) {
								JsonObject typeRegistry = class_3518.method_15296(variants, variant.toLowerCase());
								if (typeRegistry != null) {
									isTexturedEntity = TexturedEntity.setTexturedEntity(isTexturedEntity, class_3518.method_15258(typeRegistry, "enabled", true));
								}
							}
						}
					}
				}
				if (isTexturedEntity) {
					String variantNamespace = variant != null ? IdentifierHelper.getStringPart(IdentifierHelper.Type.NAMESPACE, variant) : "minecraft";
					String variantKey = variant != null ? "_" + IdentifierHelper.getStringPart(IdentifierHelper.Type.KEY, variant) : "";
					cir.setReturnValue(((PerspectiveTamedRenderState)wolfEntityRenderState).perspective$getTamed() ? TexturedEntity.getTexture(wolfEntityRenderState, variantNamespace, "", variantKey + "_tame", cir.getReturnValue()) : (wolfEntityRenderState.field_53624 ? TexturedEntity.getTexture(wolfEntityRenderState, variantNamespace, "", variantKey + "_angry", cir.getReturnValue()) : TexturedEntity.getTexture(wolfEntityRenderState, variantNamespace, "", variantKey, cir.getReturnValue())));
				}
			}
		}
	}
}