/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.textured_entity.minecraft.zombie;

import com.mclegoman.perspective.client.entity.EntityModels;
import com.mclegoman.perspective.client.entity.model.LivingEntityCapeModel;
import com.mclegoman.perspective.client.entity.renderer.feature.EntityCapeFeatureRenderer;
import com.mclegoman.perspective.client.entity.renderer.feature.OverlayFeatureRenderer;
import com.mclegoman.perspective.common.data.Data;
import net.minecraft.class_10086;
import net.minecraft.class_1642;
import net.minecraft.class_2960;
import net.minecraft.class_3886;
import net.minecraft.class_5617;
import net.minecraft.class_623;
import net.minecraft.class_968;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_3886.class)
public abstract class ZombieEntityRendererMixin extends class_968<class_1642, class_10086, class_623<class_10086>> {
	protected ZombieEntityRendererMixin(class_5617.class_5618 context, class_623<class_10086> mainModel, class_623<class_10086> babyMainModel, class_623<class_10086> armorInnerModel, class_623<class_10086> armorOuterModel, class_623<class_10086> babyArmorInnerModel, class_623<class_10086> babyArmorOuterModel) {
		super(context, mainModel, babyMainModel, armorInnerModel, armorOuterModel, babyArmorInnerModel, babyArmorOuterModel);
	}
	@Inject(method = "<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;)V", at = @At("TAIL"))
	private void perspective$init(class_5617.class_5618 context, CallbackInfo ci) {
		this.method_4046(new OverlayFeatureRenderer<>(this, new class_623<>(context.method_32167(EntityModels.zombieOverlay)), new class_623<>(context.method_32167(EntityModels.babyZombieOverlay)), class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/zombie/zombie_overlay.png")));
		this.method_4046(new EntityCapeFeatureRenderer.Builder(this, new LivingEntityCapeModel(context.method_32167(EntityModels.entityCape)), class_2960.method_60655(Data.getVersion().getID(), "textures/entity/minecraft/zombie/zombie_cape.png")).build());
	}
}