/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.ui;

import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.ui.UIBackground;
import com.mclegoman.perspective.client.ui.UIBackgroundData;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_437.class)
public abstract class ScreenMixin {
	@Inject(method = "renderBackground", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/Screen;applyBlur()V"))
	private void perspective$renderBackground(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
		UIBackgroundData data = UIBackground.getCurrentUIBackground();
		if (ClientData.minecraft.field_1687 != null && data.getRenderWorld() != null) data.getRenderWorld().run(context);
	}
	@Inject(method = "renderPanoramaBackground", at = @At(value = "HEAD"), cancellable = true)
	private void perspective$renderPanoramaBackground(class_332 context, float delta, CallbackInfo ci) {
		UIBackgroundData data = UIBackground.getCurrentUIBackground();
		if (data.getRenderMenu() != null) data.getRenderMenu().run(context);
		if (!data.getRenderPanorama()) ci.cancel();
	}
	@Inject(method = "renderDarkening(Lnet/minecraft/client/gui/DrawContext;IIII)V", at = @At(value = "HEAD"), cancellable = true)
	private void perspective$renderDarkening(class_332 context, int x, int y, int width, int height, CallbackInfo ci) {
		if (!UIBackground.getCurrentUIBackground().getRenderDarkening()) ci.cancel();
	}
}