/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.ui;

import com.mclegoman.luminance.client.events.Execute;
import com.mclegoman.luminance.mixin.client.shaders.GameRendererAccessor;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.ui.UIBackground;
import com.mclegoman.perspective.client.ui.UIBackgroundData;
import net.minecraft.class_332;
import net.minecraft.class_442;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_442.class)
public abstract class TitleScreenMixin {
	@Inject(method = "renderPanoramaBackground", at = @At(value = "HEAD"), cancellable = true)
	private void perspective$renderTitleScreen(class_332 context, float delta, CallbackInfo ci) {
		UIBackgroundData data = UIBackground.getCurrentUIBackground();
		if (data.getRenderTitleScreen() != null) data.getRenderTitleScreen().run(context);
		if (!data.getRenderTitleScreenPanorama()) {
			// Since we're disabling the panorama, we have to execute afterPanoramaRender.
			Execute.afterPanoramaRender(((GameRendererAccessor) ClientData.minecraft.field_1773).getPool());
			ci.cancel();
		}
	}
}