/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.zoom;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.zoom.Zoom;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_757.class)
public abstract class GameRendererMixin {
	@Shadow
	public abstract boolean isRenderingPanorama();

	@ModifyExpressionValue(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/GameRenderer;getFov(Lnet/minecraft/client/render/Camera;FZ)F"), method = "renderHand")
	private float perspective$renderHand(float fov) {
		return Zoom.canZoom() ? Zoom.fov : fov;
	}
	@Inject(method = "updateFovMultiplier", at = @At("TAIL"))
	private void perspective$updateFovMultiplier(CallbackInfo ci) {
		if (Zoom.canZoom()) Zoom.updateMultiplier();
	}
	@ModifyReturnValue(method = "getFov", at = @At("RETURN"))
	private float perspective$getFov(float fov, class_4184 camera, float tickDelta, boolean changingFov) {
		if (camera != null && Zoom.canZoom()) {
			Zoom.fov = fov;
			float newFOV = fov;
			if (!this.isRenderingPanorama()) {
				if (PerspectiveConfig.config.zoomTransition.value().equals("instant")) {
					newFOV *= Zoom.getMultiplier();
				}
				if (PerspectiveConfig.config.zoomTransition.value().equals("smooth")) {
					newFOV *= class_3532.method_16439(tickDelta, Zoom.getPrevMultiplier(), Zoom.getMultiplier());
				}
			}
			if (Zoom.getZoomType().equals(Zoom.Logarithmic.getIdentifier())) Zoom.zoomFOV = Zoom.Logarithmic.getLimitFOV(newFOV);
			if (Zoom.getZoomType().equals(Zoom.Linear.getIdentifier())) Zoom.zoomFOV = Zoom.Linear.getLimitFOV(newFOV);
			return Zoom.zoomFOV;
		}
		return fov;
	}
	@ModifyExpressionValue(method = "tiltViewWhenHurt", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/option/SimpleOption;getValue()Ljava/lang/Object;"))
	private Object perspective$getDamageTiltStrength(Object value) {
		return (value instanceof Double && Zoom.canZoom() && Zoom.isScaled()) ? ((Double)value) * Math.max(Zoom.getMultiplierFromFOV(), 0.001) : value;
	}
	@ModifyExpressionValue(method = "tiltViewWhenHurt", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;getDamageTiltYaw()F"))
	private float perspective$getDamageTiltYaw(float value) {
		return (Zoom.canZoom() && Zoom.isScaled()) ? (float) (value * Math.max(Zoom.getMultiplierFromFOV(), 0.001)) : value;
	}
	@Inject(method = "bobView", at = @At(value = "HEAD"), cancellable = true)
	private void perspective$bobViewStrideDistance(class_4587 matrices, float tickDelta, CallbackInfo ci) {
		if (Zoom.canZoom()) {
			if (Zoom.isScaled()) {
				if (ClientData.minecraft.field_1724 != null) {
					float f = ClientData.minecraft.field_1724.field_53039 - ClientData.minecraft.field_1724.field_53038;
					float g = -(ClientData.minecraft.field_1724.field_53039 + f * tickDelta);
					float h = (float) (class_3532.method_16439(tickDelta, ClientData.minecraft.field_1724.field_7505, ClientData.minecraft.field_1724.field_7483) * Math.max(Zoom.getMultiplier(), 0.001));
					matrices.method_46416(class_3532.method_15374(g * 3.1415927F) * h * 0.5F, -Math.abs(class_3532.method_15362(g * 3.1415927F) * h), 0.0F);
					matrices.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15374(g * 3.1415927F) * h * 3.0F));
					matrices.method_22907(class_7833.field_40714.rotationDegrees(Math.abs(class_3532.method_15362(g * 3.1415927F - 0.2F) * h) * 5.0F));
				}
				ci.cancel();
			}
		}
	}
}