/*
    Perspective
    Contributor(s): dannytaylor
    Github: https://github.com/mclegoman/perspective
    Licence: GNU LGPLv3
*/

package com.mclegoman.perspective.mixin.client.zoom;

import com.mclegoman.perspective.client.data.ClientData;
import com.mclegoman.perspective.client.zoom.Zoom;
import net.minecraft.class_312;
import net.minecraft.class_3532;
import net.minecraft.class_9928;
import com.mclegoman.perspective.client.config.PerspectiveConfig;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(priority = 100, value = class_312.class)
public abstract class MouseMixin {
	@Shadow @Final private class_9928 scroller;

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;isSpectator()Z"), method = "onMouseScroll", cancellable = true)
	private void perspective$onMouseScroll(long window, double horizontal, double vertical, CallbackInfo ci) {
		// Zoom.isZooming() checks Zoom.canZoom(), so we don't need to check it again.
		if (Zoom.isZooming()) {
			boolean discreteMouseScroll = ClientData.minecraft.field_1690.method_42439().method_41753();
			double mouseWheelSensitivity = ClientData.minecraft.field_1690.method_41806().method_41753();
			double calculatedScroll = (discreteMouseScroll ? Math.signum(vertical) : vertical) * mouseWheelSensitivity;
			Vector2i vector2i = this.scroller.method_61971(calculatedScroll, calculatedScroll);
			if (vector2i.y != 0) {
				Zoom.zoom(vector2i.y, PerspectiveConfig.config.zoomIncrementSize.value());
				ci.cancel();
			}
		}
	}
	@Inject(at = @At("HEAD"), method = "onMouseButton", cancellable = true)
	private void perspective$onMouseButton(long window, int button, int action, int mods, CallbackInfo ci) {
		// Zoom.isZooming() checks Zoom.canZoom(), so we don't need to check it again.
		if (Zoom.isZooming()) {
			if (button == 2) {
				Zoom.reset();
				ci.cancel();
			}
		}
	}

	@Inject(method = "updateMouse", at = @At(value = "HEAD"))
	private void perspective$updateTime(double timeDelta, CallbackInfo ci) {
		if (Zoom.canZoom() && Zoom.isSmoothCamera()) Zoom.timeDelta = timeDelta;
	}
	@ModifyVariable(method = "updateMouse", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/tutorial/TutorialManager;onUpdateMouse(DD)V"), ordinal = 1)
	private double perspective$updateXSensitivity(double x) {
		// Zoom.isZooming() checks Zoom.canZoom(), so we don't need to check it again.
		if (Zoom.isZooming()) {
			if (Zoom.isSmoothCamera()) x = Zoom.smoothX.method_15429(x * Zoom.getMouseSensitivity(), Zoom.timeDelta * Zoom.getMouseSensitivity());
			if (Zoom.isScaled() && ClientData.minecraft.field_1724 != null) {
				double angle = class_3532.method_15362((ClientData.minecraft.field_1724.method_36455() / 180.0F) * class_3532.field_29844);
				x = (x * (1.0F / Math.max((angle < 0) ? angle * -1.0F : angle, (Math.max(Zoom.getMultiplierFromFOV(), 0.0F) + 1.0F) / 11.0F))) * Zoom.getMultiplierFromFOV();
			}
		}
		return x;
	}
	@ModifyVariable(method = "updateMouse", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/tutorial/TutorialManager;onUpdateMouse(DD)V"), ordinal = 2)
	private double perspective$updateYSensitivity(double y) {
		// Zoom.isZooming() checks Zoom.canZoom(), so we don't need to check it again.
		if (Zoom.isZooming()) {
			if (Zoom.isSmoothCamera()) y = Zoom.smoothY.method_15429(y * Zoom.getMouseSensitivity(), Zoom.timeDelta * Zoom.getMouseSensitivity());
			if (Zoom.isScaled()) {
				return y * Zoom.getMultiplierFromFOV();
			}
		}
		return y;
	}
}