/*
 * Decompiled with CFR 0.152.
 */
package com.gali.ae2_auto_pattern_upload.client.gui;

import com.gali.ae2_auto_pattern_upload.network.ModNetwork;
import com.gali.ae2_auto_pattern_upload.network.UploadPatternPacket;
import com.gali.ae2_auto_pattern_upload.util.RecipeNameUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class GuiProviderSelect
extends GuiScreen {
    private static final int BUTTON_PREV = 100;
    private static final int BUTTON_NEXT = 101;
    private static final int BUTTON_RELOAD = 102;
    private static final int BUTTON_ADD = 103;
    private static final int BUTTON_DELETE = 104;
    private static final int BUTTON_CLOSE = 105;
    private static final int ENTRY_BUTTON_BASE = 200;
    private static final int PAGE_SIZE = 6;
    private final GuiScreen parent;
    private final List<Long> ids;
    private final List<String> names;
    private final List<Integer> emptySlots;
    private final List<GroupEntry> groups = new ArrayList<GroupEntry>();
    private final List<GroupEntry> filtered = new ArrayList<GroupEntry>();
    private GuiTextField searchBox;
    private GuiTextField mappingField;
    private String query = "";
    private int page = 0;
    private boolean needsRefresh = false;
    private String lastAddedMappingName = null;

    public GuiProviderSelect(List<Long> ids, List<String> names, List<Integer> emptySlots) {
        this(null, ids, names, emptySlots);
    }

    public GuiProviderSelect(GuiScreen parent, List<Long> ids, List<String> names, List<Integer> emptySlots) {
        this.parent = parent;
        this.ids = ids == null ? new ArrayList<Long>() : new ArrayList<Long>(ids);
        this.names = names == null ? new ArrayList<String>() : new ArrayList<String>(names);
        this.emptySlots = emptySlots == null ? new ArrayList<Integer>() : new ArrayList<Integer>(emptySlots);
        String recent = RecipeNameUtil.getLastRecipeName();
        if (recent != null && !recent.isEmpty()) {
            this.query = recent;
            RecipeNameUtil.clearLastRecipeName();
        }
        this.buildGroups();
        this.applyFilter();
    }

    private void buildGroups() {
        LinkedHashMap<String, GroupEntry> map = new LinkedHashMap<String, GroupEntry>();
        for (int i = 0; i < this.names.size(); ++i) {
            String name = this.names.get(i);
            long id = this.ids.get(i);
            int slots = this.emptySlots.get(i);
            GroupEntry entry = (GroupEntry)map.get(name);
            if (entry == null) {
                entry = new GroupEntry();
                entry.name = name;
                map.put(name, entry);
            }
            ++entry.count;
            entry.totalSlots += Math.max(0, slots);
            if (slots <= entry.bestSlots && entry.id != 0L) continue;
            entry.bestSlots = Math.max(0, slots);
            entry.id = id;
        }
        this.groups.clear();
        this.groups.addAll(map.values());
    }

    private void applyFilter() {
        this.filtered.clear();
        String q = this.query == null ? "" : this.query.trim().toLowerCase();
        for (GroupEntry entry : this.groups) {
            if (!q.isEmpty() && !entry.name.toLowerCase().contains(q)) continue;
            this.filtered.add(entry);
        }
        if (!q.isEmpty() && this.filtered.isEmpty()) {
            this.filtered.addAll(this.groups);
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int centerX = this.field_146294_l / 2;
        int startY = this.field_146295_m / 2 - 70;
        if (this.searchBox == null) {
            this.searchBox = new GuiTextField(this.field_146289_q, centerX - 120, startY - 25, 240, 18);
            this.searchBox.func_146203_f(64);
        } else {
            this.searchBox.field_146209_f = centerX - 120;
            this.searchBox.field_146210_g = startY - 25;
        }
        this.searchBox.func_146180_a(this.query);
        int navY = startY + 150 + 10;
        if (this.mappingField == null) {
            this.mappingField = new GuiTextField(this.field_146289_q, centerX - 240, navY + 30, 180, 18);
            this.mappingField.func_146203_f(64);
        } else {
            this.mappingField.field_146209_f = centerX - 240;
            this.mappingField.field_146210_g = navY + 30;
        }
        int start = this.page * 6;
        int end = Math.min(start + 6, this.filtered.size());
        for (int i = start; i < end; ++i) {
            int localIndex = i - start;
            GroupEntry entry = this.filtered.get(i);
            String label = this.buildLabel(entry);
            GuiButton button = new GuiButton(200 + localIndex, centerX - 120, startY + localIndex * 25, 240, 20, label);
            this.field_146292_n.add(button);
        }
        GuiButton prevBtn = new GuiButton(100, centerX - 60, navY, 20, 20, "<");
        GuiButton nextBtn = new GuiButton(101, centerX + 40, navY, 20, 20, ">");
        prevBtn.field_146124_l = this.page > 0;
        nextBtn.field_146124_l = (this.page + 1) * 6 < this.filtered.size();
        this.field_146292_n.add(prevBtn);
        this.field_146292_n.add(nextBtn);
        GuiButton addBtn = new GuiButton(103, centerX - 50, navY + 30, 50, 20, this.translate("gui.ae2_auto_pattern_upload.add"));
        GuiButton reloadBtn = new GuiButton(102, centerX + 10, navY + 30, 60, 20, this.translate("gui.ae2_auto_pattern_upload.reload"));
        GuiButton delBtn = new GuiButton(104, centerX + 80, navY + 30, 50, 20, this.translate("gui.ae2_auto_pattern_upload.delete"));
        GuiButton closeBtn = new GuiButton(105, centerX + 140, navY + 30, 60, 20, this.translate("gui.cancel"));
        this.field_146292_n.add(addBtn);
        this.field_146292_n.add(reloadBtn);
        this.field_146292_n.add(delBtn);
        this.field_146292_n.add(closeBtn);
    }

    private String buildLabel(GroupEntry entry) {
        return entry.name + " (" + entry.totalSlots + ") x" + entry.count;
    }

    protected void func_146284_a(GuiButton button) {
        if (button == null || !button.field_146124_l) {
            return;
        }
        int start = this.page * 6;
        if (button.field_146127_k >= 200 && button.field_146127_k < 206) {
            int idx = start + (button.field_146127_k - 200);
            if (idx >= 0 && idx < this.filtered.size()) {
                long providerId = this.filtered.get((int)idx).id;
                this.handleSelect(providerId);
                this.field_146297_k.func_147108_a(null);
            }
            return;
        }
        switch (button.field_146127_k) {
            case 100: {
                this.changePage(-1);
                break;
            }
            case 101: {
                this.changePage(1);
                break;
            }
            case 102: {
                this.reloadMappings();
                break;
            }
            case 103: {
                this.addMappingFromUI();
                break;
            }
            case 104: {
                this.deleteMappingFromUI();
                break;
            }
            case 105: {
                this.field_146297_k.func_147108_a(this.parent);
                break;
            }
        }
    }

    protected void handleSelect(long providerId) {
        ModNetwork.CHANNEL.sendToServer((IMessage)new UploadPatternPacket(providerId));
        if (this.parent != null) {
            this.field_146297_k.func_147108_a(this.parent);
        } else {
            this.field_146297_k.func_147108_a(null);
        }
    }

    private void changePage(int delta) {
        int newPage = this.page + delta;
        if (newPage < 0) {
            return;
        }
        if (newPage * 6 >= this.filtered.size()) {
            return;
        }
        this.page = newPage;
        this.needsRefresh = true;
    }

    private void reloadMappings() {
        RecipeNameUtil.reloadMappings();
        if (this.lastAddedMappingName != null && !this.lastAddedMappingName.isEmpty()) {
            this.query = this.lastAddedMappingName;
            this.page = 0;
        }
        this.applyFilter();
        this.needsRefresh = true;
        this.sendClientMessage(this.translate("ae2_auto_pattern_upload.info.mappings_reloaded"));
    }

    private void addMappingFromUI() {
        String value;
        String key = this.query == null ? "" : this.query.trim();
        String string = value = this.mappingField == null ? "" : this.mappingField.func_146179_b().trim();
        if (key.isEmpty()) {
            this.sendClientMessage(this.translate("ae2_auto_pattern_upload.info.enter_keyword"));
            return;
        }
        if (value.isEmpty()) {
            this.sendClientMessage(this.translate("ae2_auto_pattern_upload.info.enter_mapping_name"));
            return;
        }
        if (RecipeNameUtil.addOrUpdateMapping(key, value)) {
            this.sendClientMessage(String.format(this.translate("ae2_auto_pattern_upload.info.mapping_added"), key, value));
            this.lastAddedMappingName = value;
            RecipeNameUtil.reloadMappings();
            this.applyFilter();
            this.needsRefresh = true;
        } else {
            this.sendClientMessage(this.translate("ae2_auto_pattern_upload.info.mapping_add_failed"));
        }
    }

    private void deleteMappingFromUI() {
        String value;
        String string = value = this.mappingField == null ? "" : this.mappingField.func_146179_b().trim();
        if (value.isEmpty()) {
            this.sendClientMessage(this.translate("ae2_auto_pattern_upload.info.enter_mapping_delete"));
            return;
        }
        int removed = RecipeNameUtil.removeMappingsByCnValue(value);
        if (removed > 0) {
            this.sendClientMessage(String.format(this.translate("ae2_auto_pattern_upload.info.mapping_deleted"), removed));
            RecipeNameUtil.reloadMappings();
            this.applyFilter();
            this.needsRefresh = true;
        } else {
            this.sendClientMessage(this.translate("ae2_auto_pattern_upload.info.mapping_not_found"));
        }
    }

    private void sendClientMessage(String msg) {
        if (this.field_146297_k != null && this.field_146297_k.field_71439_g != null && msg != null && !msg.isEmpty()) {
            this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
    }

    public void func_73876_c() {
        if (this.searchBox != null) {
            this.searchBox.func_146178_a();
        }
        if (this.mappingField != null) {
            this.mappingField.func_146178_a();
        }
        if (this.needsRefresh) {
            this.needsRefresh = false;
            this.func_73866_w_();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        try {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.searchBox != null) {
            this.searchBox.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.mappingField != null) {
            this.mappingField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (mouseButton == 1 && this.searchBox != null && this.isPointInRegion(this.searchBox.field_146209_f, this.searchBox.field_146210_g, this.searchBox.field_146218_h, this.searchBox.field_146219_i, mouseX, mouseY)) {
            if (!this.searchBox.func_146179_b().isEmpty()) {
                this.searchBox.func_146180_a("");
                this.query = "";
                this.page = 0;
                this.applyFilter();
                this.needsRefresh = true;
            }
            return;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        boolean handled = false;
        if (this.searchBox != null && this.searchBox.func_146201_a(typedChar, keyCode)) {
            String newQuery = this.searchBox.func_146179_b();
            if (!Objects.equals(newQuery, this.query)) {
                this.query = newQuery;
                this.page = 0;
                this.applyFilter();
                this.needsRefresh = true;
            }
            handled = true;
        }
        if (this.mappingField != null && this.mappingField.func_146201_a(typedChar, keyCode)) {
            handled = true;
        }
        if (!handled) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    private boolean isPointInRegion(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        String title = this.translate("ae2_auto_pattern_upload.select_provider");
        this.field_146289_q.func_78261_a(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, this.field_146295_m / 2 - 130, 0xFFFFFF);
        if (this.searchBox != null) {
            this.searchBox.func_146194_f();
        }
        if (this.mappingField != null) {
            this.mappingField.func_146194_f();
        }
        String mappingLabel = this.translate("gui.ae2_auto_pattern_upload.mapping_label");
        this.field_146289_q.func_78276_b(mappingLabel, this.mappingField.field_146209_f - this.field_146289_q.func_78256_a(mappingLabel) - 4, this.mappingField.field_146210_g + 2, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected String translate(String key) {
        return StatCollector.func_74838_a((String)key);
    }

    private static class GroupEntry {
        long id;
        String name;
        int totalSlots;
        int count;
        int bestSlots;

        private GroupEntry() {
        }
    }
}

