/*
 * Decompiled with CFR 0.152.
 */
package com.gali.ae2_auto_pattern_upload.network;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPatternTermEx;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.IInterfaceHost;
import appeng.parts.AEBasePart;
import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminal;
import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminalEx;
import com.glodblock.github.client.gui.container.base.FCContainerEncodeTerminal;
import com.glodblock.github.inventory.item.IItemPatternTerminal;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class UploadPatternPacket
implements IMessage {
    private long providerId;

    public UploadPatternPacket() {
    }

    public UploadPatternPacket(long providerId) {
        this.providerId = providerId;
    }

    public void fromBytes(ByteBuf buf) {
        this.providerId = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.providerId);
    }

    public static class Handler
    implements IMessageHandler<UploadPatternPacket, IMessage> {
        public IMessage onMessage(UploadPatternPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null) {
                return null;
            }
            Container container = player.field_71070_bA;
            IActionHost terminal = this.resolveTerminal(container);
            if (terminal == null) {
                return null;
            }
            SlotRestrictedInput outputSlot = this.resolveOutputSlot(container);
            if (outputSlot == null) {
                return null;
            }
            ItemStack encodedPattern = outputSlot.func_75211_c();
            if (encodedPattern == null || encodedPattern.field_77994_a <= 0) {
                return null;
            }
            if (!AEApi.instance().definitions().items().encodedPattern().isSameAs(encodedPattern)) {
                return null;
            }
            try {
                IGridNode node = terminal.getActionableNode();
                if (node == null) {
                    return null;
                }
                IGrid grid = node.getGrid();
                if (grid == null) {
                    return null;
                }
                ICraftingProvider target = this.findProvider(grid, message.providerId);
                if (target == null) {
                    return null;
                }
                boolean placedInProvider = this.insertPatternIntoProvider(target, encodedPattern.func_77946_l());
                if (placedInProvider) {
                    outputSlot.func_75215_d(null);
                    if (terminal instanceof AEBasePart) {
                        AEBasePart part = (AEBasePart)terminal;
                        part.saveChanges();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return null;
        }

        private IActionHost resolveTerminal(Container container) {
            if (container instanceof ContainerPatternTerm) {
                ContainerPatternTerm term = (ContainerPatternTerm)container;
                return term.getPatternTerminal();
            }
            if (container instanceof ContainerPatternTermEx) {
                ContainerPatternTermEx termEx = (ContainerPatternTermEx)container;
                return termEx.getPatternTerminal();
            }
            if (container instanceof ContainerFluidPatternTerminal) {
                ContainerFluidPatternTerminal fluidTerm = (ContainerFluidPatternTerminal)container;
                return this.fromPatternTerminal(fluidTerm.getPatternTerminal());
            }
            if (container instanceof ContainerFluidPatternTerminalEx) {
                ContainerFluidPatternTerminalEx fluidTermEx = (ContainerFluidPatternTerminalEx)container;
                return this.fromPatternTerminal(fluidTermEx.getPatternTerminal());
            }
            return null;
        }

        private IActionHost fromPatternTerminal(IItemPatternTerminal terminal) {
            if (terminal instanceof IActionHost) {
                IActionHost actionHost = (IActionHost)terminal;
                return actionHost;
            }
            return null;
        }

        private SlotRestrictedInput resolveOutputSlot(Container container) {
            try {
                if (container instanceof ContainerPatternTerm) {
                    ContainerPatternTerm term = (ContainerPatternTerm)container;
                    Field field = ContainerPatternTerm.class.getDeclaredField("patternSlotOUT");
                    field.setAccessible(true);
                    return (SlotRestrictedInput)field.get(term);
                }
                if (container instanceof ContainerPatternTermEx) {
                    ContainerPatternTermEx termEx = (ContainerPatternTermEx)container;
                    Field field = ContainerPatternTermEx.class.getDeclaredField("patternSlotOUT");
                    field.setAccessible(true);
                    return (SlotRestrictedInput)field.get(termEx);
                }
                if (container instanceof FCContainerEncodeTerminal) {
                    FCContainerEncodeTerminal fcContainer = (FCContainerEncodeTerminal)container;
                    Field field = FCContainerEncodeTerminal.class.getDeclaredField("patternSlotOUT");
                    field.setAccessible(true);
                    return (SlotRestrictedInput)field.get(fcContainer);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private ICraftingProvider findProvider(IGrid grid, long providerId) {
            for (Class hostClass : grid.getMachinesClasses()) {
                IMachineSet machines;
                if (!ICraftingProvider.class.isAssignableFrom(hostClass) || (machines = grid.getMachines(hostClass)) == null) continue;
                for (IGridNode machineNode : machines) {
                    IGridHost machine;
                    if (machineNode == null || !((machine = machineNode.getMachine()) instanceof ICraftingProvider) || (long)System.identityHashCode(machine) != providerId) continue;
                    return (ICraftingProvider)machine;
                }
            }
            return null;
        }

        private boolean insertPatternIntoProvider(ICraftingProvider provider, ItemStack pattern) {
            IInterfaceHost host;
            IInventory patterns;
            if (provider instanceof IInterfaceHost && (patterns = (host = (IInterfaceHost)provider).getPatterns()) != null && this.insertIntoPatternInventory(patterns, pattern)) {
                host.saveChanges();
                return true;
            }
            if (provider instanceof IInventory) {
                IInventory inventory = (IInventory)provider;
                return this.insertIntoInventory(inventory, pattern);
            }
            return false;
        }

        private boolean insertIntoPatternInventory(IInventory patterns, ItemStack pattern) {
            if (patterns == null) {
                return false;
            }
            for (int i = 0; i < patterns.func_70302_i_(); ++i) {
                ItemStack slot = patterns.func_70301_a(i);
                if (slot != null && slot.field_77994_a > 0 || !patterns.func_94041_b(i, pattern)) continue;
                ItemStack copy = pattern.func_77946_l();
                copy.field_77994_a = 1;
                patterns.func_70299_a(i, copy);
                patterns.func_70296_d();
                return true;
            }
            return false;
        }

        private boolean insertIntoInventory(IInventory inventory, ItemStack pattern) {
            if (inventory == null) {
                return false;
            }
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack slot = inventory.func_70301_a(i);
                if (slot != null && slot.field_77994_a > 0) continue;
                ItemStack copy = pattern.func_77946_l();
                copy.field_77994_a = 1;
                inventory.func_70299_a(i, copy);
                inventory.func_70296_d();
                return true;
            }
            return false;
        }
    }
}

