/*
 * Decompiled with CFR 0.152.
 */
package com.example.ae2_auto_pattern_upload.mixin.jei;

import appeng.container.implementations.ContainerPatternEncoder;
import com.example.ae2_auto_pattern_upload.util.RecipeNameUtil;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"appeng.integration.modules.jei.RecipeTransferHandler"}, remap=false)
public abstract class RecipeTransferHandlerMixin {
    @Inject(method={"transferRecipe"}, at={@At(value="HEAD")})
    private void captureProcessingCategory(Container container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer, CallbackInfoReturnable<IRecipeTransferError> cir) {
        if (!doTransfer || !(container instanceof ContainerPatternEncoder)) {
            return;
        }
        String uid = recipeLayout.getRecipeCategory().getUid();
        if (uid == null || "minecraft.crafting".equals(uid)) {
            return;
        }
        String keyword = RecipeNameUtil.mapCategoryUidToSearchKey(uid);
        if (keyword == null || keyword.isEmpty()) {
            keyword = RecipeNameUtil.deriveSearchKeyFromClassName(recipeLayout.getRecipeCategory());
        }
        if (keyword != null && !keyword.isEmpty()) {
            RecipeNameUtil.setLastRecipeName(keyword);
        }
    }
}

