/*
 * Decompiled with CFR 0.152.
 */
package com.example.ae2_auto_pattern_upload.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.Loader;

public class RecipeNameUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<String, String> RAW_MAPPINGS = new HashMap<String, String>();
    private static final Map<String, String> LOOKUP_MAPPINGS = new HashMap<String, String>();
    private static final Path CONFIG_FILE;
    private static String lastRecipeName;

    public static String deriveSearchKeyFromClassName(Object recipeObj) {
        if (recipeObj == null) {
            return null;
        }
        try {
            Class<?> cls = recipeObj.getClass();
            String simpleName = cls.getSimpleName();
            String packageName = cls.getPackage().getName().toLowerCase();
            String token = simpleName.replaceAll("Recipe$", "").replaceAll("Recipes$", "").replaceAll("Category$", "").replaceAll("JEI$", "");
            token = token.replaceAll("(?<!^)([A-Z])", " $1").toLowerCase().trim();
            String namespace = null;
            if (packageName.contains("gtceu")) {
                namespace = "gtceu";
            } else if (packageName.contains("gregtech")) {
                namespace = "gregtech";
            } else if (packageName.contains("create")) {
                namespace = "create";
            } else if (packageName.contains("immersiveengineering")) {
                namespace = "immersive";
            }
            if (namespace != null && !token.isEmpty()) {
                return namespace + " " + token;
            }
            return token;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String mapRecipeTypeToSearchKey(String recipeType) {
        if (recipeType == null || recipeType.isEmpty()) {
            return null;
        }
        String path = RecipeNameUtil.extractPath(recipeType);
        String mapped = LOOKUP_MAPPINGS.get(path.toLowerCase());
        return mapped != null ? mapped : path;
    }

    public static String mapCategoryUidToSearchKey(String categoryUid) {
        String normalized;
        if (categoryUid == null || categoryUid.isEmpty()) {
            return null;
        }
        String path = normalized = categoryUid.toLowerCase();
        int separator = normalized.indexOf(58);
        if (separator >= 0) {
            path = normalized.substring(separator + 1);
        } else {
            separator = normalized.indexOf(46);
            if (separator >= 0) {
                path = normalized.substring(separator + 1);
            }
        }
        String mapped = LOOKUP_MAPPINGS.get(path.toLowerCase());
        if (mapped != null && !mapped.isEmpty()) {
            return mapped;
        }
        return path;
    }

    private static String extractPath(String recipeType) {
        int separator = recipeType.indexOf(58);
        if (separator >= 0 && separator + 1 < recipeType.length()) {
            return recipeType.substring(separator + 1);
        }
        return recipeType;
    }

    public static void setLastRecipeName(String name) {
        lastRecipeName = name;
    }

    public static String getLastRecipeName() {
        return lastRecipeName;
    }

    public static void clearLastRecipeName() {
        lastRecipeName = null;
    }

    private static void loadMappings() {
        RAW_MAPPINGS.clear();
        LOOKUP_MAPPINGS.clear();
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            RecipeNameUtil.writeTemplate();
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(CONFIG_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj == null) {
                return;
            }
            for (Map.Entry entry : obj.entrySet()) {
                String mapped;
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (key == null || key.trim().isEmpty() || value == null || !value.isJsonPrimitive() || (mapped = value.getAsString()) == null || mapped.trim().isEmpty()) continue;
                RAW_MAPPINGS.put(key.trim(), mapped.trim());
                LOOKUP_MAPPINGS.put(key.trim().toLowerCase(), mapped.trim());
            }
        }
        catch (IOException e) {
            System.err.println("[AE2 Auto Pattern Upload] " + I18n.func_135052_a((String)"ae2_auto_pattern_upload.error.read_mappings", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static void writeTemplate() {
        JsonObject template = new JsonObject();
        template.addProperty("example.minecraft.smelting", "example_smelting");
        template.addProperty("example.appliedenergistics2.inscriber", "example_inscriber");
        try {
            Path parent = CONFIG_FILE.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            String json = GSON.toJson((JsonElement)template);
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(CONFIG_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
                writer.write(json);
            }
        }
        catch (IOException e) {
            System.err.println("[AE2 Auto Pattern Upload] " + I18n.func_135052_a((String)"ae2_auto_pattern_upload.error.create_template", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static void saveMappings() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, String> entry : RAW_MAPPINGS.entrySet()) {
            obj.addProperty(entry.getKey(), entry.getValue());
        }
        try {
            Path parent = CONFIG_FILE.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            String json = GSON.toJson((JsonElement)obj);
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(CONFIG_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
                writer.write(json);
            }
        }
        catch (IOException e) {
            System.err.println("[AE2 Auto Pattern Upload] " + I18n.func_135052_a((String)"ae2_auto_pattern_upload.error.write_mappings", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static boolean addOrUpdateMapping(String key, String value) {
        if (key == null || key.trim().isEmpty() || value == null || value.trim().isEmpty()) {
            return false;
        }
        RAW_MAPPINGS.put(key.trim(), value.trim());
        LOOKUP_MAPPINGS.put(key.trim().toLowerCase(), value.trim());
        RecipeNameUtil.saveMappings();
        return true;
    }

    public static int removeMappingsByCnValue(String cnValue) {
        if (cnValue == null || cnValue.trim().isEmpty()) {
            return 0;
        }
        String target = cnValue.trim();
        int removed = 0;
        Iterator<Map.Entry<String, String>> it = RAW_MAPPINGS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!target.equals(entry.getValue())) continue;
            LOOKUP_MAPPINGS.remove(entry.getKey().toLowerCase());
            it.remove();
            ++removed;
        }
        if (removed > 0) {
            RecipeNameUtil.saveMappings();
        }
        return removed;
    }

    public static void reloadMappings() {
        RecipeNameUtil.loadMappings();
    }

    public static Map<String, String> getMappingsView() {
        return Collections.unmodifiableMap(RAW_MAPPINGS);
    }

    static {
        Path configDir = Loader.instance().getConfigDir().toPath();
        CONFIG_FILE = configDir.resolve("ae2_auto_pattern_upload").resolve("recipe_names.json");
        RecipeNameUtil.loadMappings();
        lastRecipeName = null;
    }
}

