/*
 * Decompiled with CFR 0.152.
 */
package com.gali.ae2_auto_pattern_upload.network;

import com.gali.ae2_auto_pattern_upload.client.gui.GuiProviderSelect;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class ProvidersListS2CPacket
implements IMessage {
    private List<Long> ids;
    private List<String> names;
    private List<Integer> emptySlots;

    public ProvidersListS2CPacket() {
        this.ids = new ArrayList<Long>();
        this.names = new ArrayList<String>();
        this.emptySlots = new ArrayList<Integer>();
    }

    public ProvidersListS2CPacket(List<Long> ids, List<String> names, List<Integer> emptySlots) {
        this.ids = ids;
        this.names = names;
        this.emptySlots = emptySlots;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.ids = new ArrayList<Long>(size);
        this.names = new ArrayList<String>(size);
        this.emptySlots = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.ids.add(buf.readLong());
            int len = buf.readInt();
            byte[] nameBytes = new byte[len];
            buf.readBytes(nameBytes);
            this.names.add(new String(nameBytes, StandardCharsets.UTF_8));
            this.emptySlots.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ids.size());
        for (int i = 0; i < this.ids.size(); ++i) {
            buf.writeLong(this.ids.get(i).longValue());
            byte[] nameBytes = this.names.get(i).getBytes(StandardCharsets.UTF_8);
            buf.writeInt(nameBytes.length);
            buf.writeBytes(nameBytes);
            buf.writeInt(this.emptySlots.get(i).intValue());
        }
    }

    public static class Handler
    implements IMessageHandler<ProvidersListS2CPacket, IMessage> {
        public IMessage onMessage(final ProvidersListS2CPacket message, MessageContext ctx) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    GuiScreen current = Minecraft.func_71410_x().field_71462_r;
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiProviderSelect(current, message.ids, message.names, message.emptySlots));
                }
            });
            return null;
        }
    }
}

