/*
 * Decompiled with CFR 0.152.
 */
package com.gali.ae2_auto_pattern_upload.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionHost;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPatternTermEx;
import com.gali.ae2_auto_pattern_upload.network.ModNetwork;
import com.gali.ae2_auto_pattern_upload.network.ProvidersListS2CPacket;
import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminal;
import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminalEx;
import com.glodblock.github.inventory.item.IItemPatternTerminal;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;

public class RequestProvidersListPacket
implements IMessage {
    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }

    public static class Handler
    implements IMessageHandler<RequestProvidersListPacket, IMessage> {
        public IMessage onMessage(RequestProvidersListPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null) {
                return null;
            }
            Container container = player.field_71070_bA;
            if (!(container instanceof ContainerPatternTerm || container instanceof ContainerPatternTermEx || container instanceof ContainerFluidPatternTerminal || container instanceof ContainerFluidPatternTerminalEx)) {
                return null;
            }
            try {
                IActionHost terminal = this.resolveTerminal(container);
                if (terminal == null) {
                    return null;
                }
                IGridNode node = terminal.getActionableNode();
                if (node == null) {
                    return null;
                }
                IGrid grid = node.getGrid();
                if (grid == null) {
                    return null;
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<Integer> emptySlots = new ArrayList<Integer>();
                for (Class hostClass : grid.getMachinesClasses()) {
                    IMachineSet machines;
                    if (!ICraftingProvider.class.isAssignableFrom(hostClass) || (machines = grid.getMachines(hostClass)) == null) continue;
                    for (IGridNode machineNode : machines) {
                        IGridHost machine;
                        if (machineNode == null || !((machine = machineNode.getMachine()) instanceof ICraftingProvider)) continue;
                        ICraftingProvider provider = (ICraftingProvider)machine;
                        long id = System.identityHashCode(provider);
                        String name = this.resolveProviderName(machine);
                        ids.add(id);
                        names.add(name);
                        emptySlots.add(this.estimateEmptySlots(provider));
                    }
                }
                ModNetwork.CHANNEL.sendTo((IMessage)new ProvidersListS2CPacket(ids, names, emptySlots), player);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return null;
        }

        private IActionHost resolveTerminal(Container container) {
            if (container instanceof ContainerPatternTerm) {
                ContainerPatternTerm term = (ContainerPatternTerm)container;
                return term.getPatternTerminal();
            }
            if (container instanceof ContainerPatternTermEx) {
                ContainerPatternTermEx termEx = (ContainerPatternTermEx)container;
                return termEx.getPatternTerminal();
            }
            if (container instanceof ContainerFluidPatternTerminal) {
                ContainerFluidPatternTerminal fluidTerm = (ContainerFluidPatternTerminal)container;
                return this.fromPatternTerminal(fluidTerm.getPatternTerminal());
            }
            if (container instanceof ContainerFluidPatternTerminalEx) {
                ContainerFluidPatternTerminalEx fluidTermEx = (ContainerFluidPatternTerminalEx)container;
                return this.fromPatternTerminal(fluidTermEx.getPatternTerminal());
            }
            return null;
        }

        private IActionHost fromPatternTerminal(IItemPatternTerminal terminal) {
            if (terminal instanceof IActionHost) {
                IActionHost actionHost = (IActionHost)terminal;
                return actionHost;
            }
            return null;
        }

        private int estimateEmptySlots(ICraftingProvider provider) {
            return 0;
        }

        private String resolveProviderName(Object machine) {
            String name = "Crafting Provider";
            if (machine instanceof TileEntity) {
                TileEntity tile = (TileEntity)machine;
                try {
                    if (tile.func_145838_q() != null) {
                        name = tile.func_145838_q().func_149732_F();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (machine instanceof IInventory) {
                    IInventory inv = (IInventory)machine;
                    try {
                        if (inv.func_145818_k_()) {
                            name = inv.func_145825_b();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return name;
        }
    }
}

