/*
 * Decompiled with CFR 0.152.
 */
package com.gali.ae2_auto_pattern_upload.util;

import codechicken.nei.recipe.IRecipeHandler;
import com.gali.ae2_auto_pattern_upload.MyMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.Loader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.util.StatCollector;

public final class RecipeNameUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<String, String> RAW_MAPPINGS = new HashMap<String, String>();
    private static final Map<String, String> LOOKUP_MAPPINGS = new HashMap<String, String>();
    private static final Path CONFIG_FILE;
    private static final Pattern CAMEL_CASE_SPLITTER;
    private static String lastRecipeName;

    private RecipeNameUtil() {
    }

    public static synchronized void setLastRecipeName(String name) {
        lastRecipeName = name;
    }

    public static synchronized String getLastRecipeName() {
        return lastRecipeName;
    }

    public static synchronized void clearLastRecipeName() {
        lastRecipeName = null;
    }

    public static synchronized boolean addOrUpdateMapping(String key, String value) {
        if (key == null || key.trim().isEmpty() || value == null || value.trim().isEmpty()) {
            return false;
        }
        RAW_MAPPINGS.put(key.trim(), value.trim());
        LOOKUP_MAPPINGS.put(RecipeNameUtil.normalizeKey(key), value.trim());
        RecipeNameUtil.saveMappings();
        return true;
    }

    public static synchronized int removeMappingsByCnValue(String cnValue) {
        if (cnValue == null || cnValue.trim().isEmpty()) {
            return 0;
        }
        String target = cnValue.trim();
        int removed = 0;
        Iterator<Map.Entry<String, String>> iterator = RAW_MAPPINGS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!Objects.equals(entry.getValue(), target)) continue;
            iterator.remove();
            LOOKUP_MAPPINGS.remove(RecipeNameUtil.normalizeKey(entry.getKey()));
            ++removed;
        }
        if (removed > 0) {
            RecipeNameUtil.saveMappings();
        }
        return removed;
    }

    public static synchronized void reloadMappings() {
        RecipeNameUtil.loadMappings();
    }

    public static synchronized Map<String, String> getMappingsView() {
        return Collections.unmodifiableMap(RAW_MAPPINGS);
    }

    private static synchronized void loadMappings() {
        RAW_MAPPINGS.clear();
        LOOKUP_MAPPINGS.clear();
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            RecipeNameUtil.writeTemplate();
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(CONFIG_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj == null) {
                return;
            }
            for (Map.Entry entry : obj.entrySet()) {
                String mapped;
                JsonElement value;
                String key = (String)entry.getKey();
                if (key == null || key.trim().isEmpty() || (value = (JsonElement)entry.getValue()) == null || !value.isJsonPrimitive() || (mapped = value.getAsString()) == null || mapped.trim().isEmpty()) continue;
                RAW_MAPPINGS.put(key.trim(), mapped.trim());
                LOOKUP_MAPPINGS.put(RecipeNameUtil.normalizeKey(key), mapped.trim());
            }
        }
        catch (IOException e) {
            MyMod.LOG.warn(StatCollector.func_74837_a((String)"ae2_auto_pattern_upload.error.read_mappings", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static void writeTemplate() {
        JsonObject template = new JsonObject();
        template.addProperty("example.crafting", "example_crafting");
        template.addProperty("example.processing", "example_processing");
        try {
            Path parent = CONFIG_FILE.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(CONFIG_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((JsonElement)template));
            }
        }
        catch (IOException e) {
            MyMod.LOG.warn(StatCollector.func_74837_a((String)"ae2_auto_pattern_upload.error.create_template", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static void saveMappings() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, String> entry : RAW_MAPPINGS.entrySet()) {
            obj.addProperty(entry.getKey(), entry.getValue());
        }
        try {
            Path parent = CONFIG_FILE.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(CONFIG_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((JsonElement)obj));
            }
        }
        catch (IOException e) {
            MyMod.LOG.warn(StatCollector.func_74837_a((String)"ae2_auto_pattern_upload.error.write_mappings", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static String mapCategoryUidToSearchKey(String categoryUid) {
        if (categoryUid == null || categoryUid.isEmpty()) {
            return null;
        }
        String normalized = categoryUid.trim().toLowerCase(Locale.ROOT);
        int colon = normalized.indexOf(58);
        int dot = normalized.indexOf(46);
        String path = colon >= 0 ? normalized.substring(colon + 1) : (dot >= 0 ? normalized.substring(dot + 1) : normalized);
        String mapped = LOOKUP_MAPPINGS.get(path);
        if (mapped != null && !mapped.isEmpty()) {
            return mapped;
        }
        return RecipeNameUtil.toDisplayString(path);
    }

    public static String deriveSearchKeyFromClassName(Object recipeObj) {
        if (recipeObj == null) {
            return null;
        }
        try {
            String simpleName = recipeObj.getClass().getSimpleName();
            String packageName = recipeObj.getClass().getPackage().getName().toLowerCase(Locale.ROOT);
            String token = CAMEL_CASE_SPLITTER.matcher(simpleName).replaceAll(" $1").replace("_", " ").replace("-", " ").trim().toLowerCase(Locale.ROOT);
            token = token.replace(" recipe", "").replace(" handler", "").trim();
            String namespace = null;
            if (packageName.contains("gregtech")) {
                namespace = "gregtech";
            } else if (packageName.contains("gtceu")) {
                namespace = "gtceu";
            } else if (packageName.contains("thermal")) {
                namespace = "thermal";
            } else if (packageName.contains("botania")) {
                namespace = "botania";
            } else if (packageName.contains("immersive")) {
                namespace = "immersive";
            }
            if (namespace != null && !token.isEmpty()) {
                return namespace + " " + token;
            }
            if (!token.isEmpty()) {
                return token;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void captureFromRecipeHandler(IRecipeHandler handler) {
        String keyword = RecipeNameUtil.mapRecipeHandlerToSearchKey(handler);
        if (keyword != null && !keyword.isEmpty()) {
            RecipeNameUtil.setLastRecipeName(keyword);
        }
    }

    public static String mapRecipeHandlerToSearchKey(IRecipeHandler handler) {
        if (handler == null) {
            return null;
        }
        try {
            String overlayId = RecipeNameUtil.safeOverlayIdentifier(handler);
            if (overlayId != null) {
                String mapped = RecipeNameUtil.mapStringToMapping(overlayId);
                if (mapped != null) {
                    return mapped;
                }
                return RecipeNameUtil.toDisplayString(overlayId);
            }
        }
        catch (Throwable overlayId) {
            // empty catch block
        }
        try {
            String recipeName = handler.getRecipeName();
            if (recipeName != null && !recipeName.trim().isEmpty()) {
                String mapped = RecipeNameUtil.mapStringToMapping(recipeName);
                if (mapped != null) {
                    return mapped;
                }
                return recipeName.trim();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return RecipeNameUtil.toDisplayString(handler.getClass().getSimpleName());
    }

    private static String mapStringToMapping(String raw) {
        if (raw == null || raw.trim().isEmpty()) {
            return null;
        }
        String normalized = RecipeNameUtil.normalizeKey(raw);
        String mapped = LOOKUP_MAPPINGS.get(normalized);
        if (mapped != null && !mapped.isEmpty()) {
            return mapped;
        }
        return null;
    }

    private static String safeOverlayIdentifier(IRecipeHandler handler) {
        try {
            String id = handler.getOverlayIdentifier();
            if (id != null && !id.trim().isEmpty()) {
                return id;
            }
        }
        catch (Throwable id) {
            // empty catch block
        }
        try {
            String tabName = handler.getRecipeTabName();
            if (tabName != null && !tabName.trim().isEmpty()) {
                return tabName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String normalizeKey(String key) {
        return key.trim().toLowerCase(Locale.ROOT);
    }

    private static String toDisplayString(String raw) {
        if (raw == null) {
            return null;
        }
        String cleaned = raw.replace('_', ' ').replace('-', ' ').replace('.', ' ').replace(':', ' ');
        cleaned = CAMEL_CASE_SPLITTER.matcher(cleaned).replaceAll(" $1");
        cleaned = cleaned.replaceAll("\\s+", " ").trim();
        return cleaned;
    }

    static {
        CAMEL_CASE_SPLITTER = Pattern.compile("(?<!^)([A-Z])");
        lastRecipeName = null;
        Path configDir = Loader.instance().getConfigDir().toPath();
        CONFIG_FILE = configDir.resolve("ae2_auto_pattern_upload").resolve("recipe_names.json");
        RecipeNameUtil.loadMappings();
    }
}

