/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.commands;

import gs.mclo.commands.ICommandSourceAccessor;
import gs.mclo.commands.LogDirectory;
import gs.mclo.commands.Permission;
import gs.mclo.components.MinecraftComponent;
import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;

public class CommandSourceStackAccessor
implements ICommandSourceAccessor<MinecraftComponent> {
    private final CommandSourceStack source;

    public CommandSourceStackAccessor(CommandSourceStack source) {
        this.source = source;
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.source.hasPermission(permission.level());
    }

    @Override
    public Path getRootDirectory() {
        return this.source.getServer().getServerDirectory();
    }

    @Override
    public Collection<LogDirectory> getLogDirectories() {
        return LogDirectory.getVanillaLogDirectories(this.getRootDirectory());
    }

    @Override
    public void sendFailure(MinecraftComponent message) {
        this.source.sendFailure((Component)message.getBoxed());
    }

    @Override
    public void sendSuccess(MinecraftComponent message, boolean allowLogging) {
        this.source.sendSuccess(message::getBoxed, allowLogging);
    }
}

