/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.commands;

import gs.mclo.Constants;
import gs.mclo.commands.ClientCommandSourceStackBuildContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.fml.loading.FMLLoader;

public class NeoForgeClientCommandSourceStackBuildContext
extends ClientCommandSourceStackBuildContext {
    private static final Pattern NEOFORGE_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:-beta)?");
    private boolean supportsClickEvents = false;

    public NeoForgeClientCommandSourceStackBuildContext() {
        try {
            if (this.isMinVersion(new int[]{21, 4, 5})) {
                this.supportsClickEvents = true;
            }
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to parse NeoForge version", (Throwable)e);
        }
    }

    @Override
    public boolean supportsClientCommandClickEvents() {
        return this.supportsClickEvents;
    }

    protected boolean isMinVersion(int[] minVersions) {
        String version = FMLLoader.versionInfo().neoForgeVersion();
        Matcher matcher = NEOFORGE_VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalStateException("Failed to parse NeoForge version: " + version);
        }
        if (matcher.groupCount() != minVersions.length) {
            throw new IllegalStateException("Expected match group count : " + version);
        }
        for (int i = 0; i < minVersions.length; ++i) {
            int minVersion = minVersions[i];
            int foundVersion = Integer.parseInt(matcher.group(i + 1));
            if (foundVersion > minVersion) {
                return true;
            }
            if (foundVersion >= minVersion) continue;
            return false;
        }
        return true;
    }
}

