/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.serde.ObjectDeserializer;
import com.electronwill.nightconfig.core.serde.ObjectSerializer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import gs.mclo.Configuration;
import gs.mclo.Constants;
import gs.mclo.api.Instance;
import gs.mclo.api.MclogsClient;
import gs.mclo.commands.BuildContext;
import gs.mclo.commands.Command;
import gs.mclo.commands.MclogsCommand;
import gs.mclo.commands.MclogsListCommand;
import gs.mclo.commands.MclogsShareCommand;
import gs.mclo.components.IComponent;
import gs.mclo.components.IComponentFactory;
import gs.mclo.components.IStyle;
import gs.mclo.platform.Services;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MclogsCommon {
    protected MclogsClient apiClient;
    protected FileConfig configFile;
    protected Configuration config = new Configuration();

    public void init() {
        this.apiClient = new MclogsClient("mclogs-integration/" + Services.platform().getPlatformName(), Services.platform().getModVersion());
        this.apiClient.setMinecraftVersion(Services.platform().getMinecraftVersion());
        this.configFile = Services.platform().getConfig().autoreload().onAutoReload(this::onConfigLoaded).autosave().build();
        this.configFile.load();
        this.migrateOldConfigFields();
        this.onConfigLoaded(false);
        ObjectSerializer.standard().serializeFields((Object)this.config, (Config)this.configFile);
        this.configFile.save();
    }

    protected void migrateOldConfigFields() {
        for (Map.Entry<String, String> entry : Map.of("view-logs-url", "viewLogsUrl", "api-base-url", "apiBaseUrl").entrySet()) {
            Object value;
            String oldKey = entry.getKey();
            String newKey = entry.getValue();
            if (this.configFile.get(newKey) != null || (value = this.configFile.get(oldKey)) == null) continue;
            this.configFile.set(newKey, this.configFile.get(oldKey));
            this.configFile.remove(oldKey);
        }
    }

    protected void onConfigLoaded() {
        this.onConfigLoaded(true);
    }

    protected void onConfigLoaded(boolean log) {
        ObjectDeserializer.standard().deserializeFields((UnmodifiableConfig)this.configFile, (Object)this.config);
        Instance instance = new Instance(this.config.apiBaseUrl, this.config.viewLogsUrl);
        this.apiClient.setInstance(instance);
        if (log) {
            Constants.LOG.info("Reloaded configuration.");
        }
    }

    protected <ComponentType extends IComponent<ComponentType, StyleType, ClickEventType>, StyleType extends IStyle<StyleType, ClickEventType>, ClickEventType> Collection<Command<ComponentType, StyleType, ClickEventType>> getCommands(IComponentFactory<ComponentType, StyleType, ClickEventType> componentFactory) {
        return List.of(new MclogsCommand<ComponentType, StyleType, ClickEventType>(this, componentFactory), new MclogsListCommand<ComponentType, StyleType, ClickEventType>(this, componentFactory), new MclogsShareCommand<ComponentType, StyleType, ClickEventType>(this, componentFactory));
    }

    protected <T, ComponentType extends IComponent<ComponentType, StyleType, ClickEventType>, StyleType extends IStyle<StyleType, ClickEventType>, ClickEventType> void registerCommands(CommandDispatcher<T> dispatcher, BuildContext<T, ComponentType> context, IComponentFactory<ComponentType, StyleType, ClickEventType> componentFactory) {
        Constants.LOG.info("Registering command {}", (Object)context.environment.commandName);
        LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)context.environment.commandName);
        for (Command<ComponentType, StyleType, ClickEventType> command : this.getCommands(componentFactory)) {
            dispatcher.register(command.build(context, builder));
        }
    }

    public MclogsClient getApiClient() {
        return this.apiClient;
    }
}

