/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import gs.mclo.Constants;
import gs.mclo.MclogsCommon;
import gs.mclo.commands.BuildContext;
import gs.mclo.commands.ICommandSourceAccessor;
import gs.mclo.commands.LogDirectory;
import gs.mclo.components.ClickEventAction;
import gs.mclo.components.IComponent;
import gs.mclo.components.IComponentFactory;
import gs.mclo.components.IStyle;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;

public abstract class Command<ComponentType extends IComponent<ComponentType, StyleType, ClickEventType>, StyleType extends IStyle<StyleType, ClickEventType>, ClickEventType> {
    protected final MclogsCommon common;
    protected final IComponentFactory<ComponentType, StyleType, ClickEventType> componentFactory;

    public Command(MclogsCommon common, IComponentFactory<ComponentType, StyleType, ClickEventType> componentFactory) {
        this.common = common;
        this.componentFactory = componentFactory;
    }

    public abstract <T> LiteralArgumentBuilder<T> build(BuildContext<T, ComponentType> var1, LiteralArgumentBuilder<T> var2);

    public <T> int share(CommandContext<T> context, BuildContext<T, ComponentType> buildContext, String filename) {
        Path logDir;
        ICommandSourceAccessor<ComponentType> source = buildContext.mapSource(context.getSource());
        Path[] logDirectories = (Path[])source.getLogDirectories().stream().map(LogDirectory::path).toArray(Path[]::new);
        Path path = null;
        Path[] pathArray = logDirectories;
        int n = pathArray.length;
        for (int i = 0; i < n && !(path = (logDir = pathArray[i]).resolve(filename)).toFile().exists(); ++i) {
        }
        if (path == null || !path.toFile().exists() || !this.isFileInAllowedDirectory(path, logDirectories)) {
            source.sendFailure(this.fileNotFoundMessage(filename, context));
            return -1;
        }
        Constants.LOG.info("Sharing {}", (Object)source.getRootDirectory().relativize(path));
        ((CompletableFuture)this.common.getApiClient().uploadLog(path).thenAccept(response -> {
            if (response.isSuccess()) {
                Object link = this.componentFactory.literal(response.getUrl()).style(this.openUrlStyle(response.getUrl()));
                Object message = this.componentFactory.literal("Your log has been uploaded: ").append(link);
                source.sendSuccess(message, true);
            } else {
                Constants.LOG.error("An error occurred when uploading your log: {}", (Object)response.getError());
                source.sendFailure(this.genericErrorMessage());
            }
        })).exceptionally(e -> {
            Constants.LOG.error("An error occurred when uploading your log", e);
            source.sendFailure(this.genericErrorMessage());
            return null;
        });
        return 1;
    }

    protected String command(CommandContext<?> context, String ... args) {
        StringBuilder command = new StringBuilder("/" + ((ParsedCommandNode)context.getNodes().getFirst()).getNode().getName());
        for (String arg : args) {
            command.append(" ").append(arg);
        }
        return command.toString();
    }

    protected ComponentType fileNotFoundMessage(String filename, CommandContext<?> context) {
        String command = this.command(context, "list");
        return (ComponentType)this.componentFactory.literal("There's no log, crash- or network protocol error report with the name '" + filename + "'.").append("\n").append("Use ").append(this.componentFactory.literal(command).style(this.runCommandStyle(command))).append(" to list all logs.");
    }

    protected ComponentType genericErrorMessage() {
        return this.componentFactory.literal("An error occurred. Check your log for more details");
    }

    protected StyleType runCommandStyle(String command) {
        return this.clickableStyle(this.componentFactory.clickEvent(ClickEventAction.RUN_COMMAND, command));
    }

    protected StyleType openUrlStyle(String url) {
        return this.clickableStyle(this.componentFactory.clickEvent(ClickEventAction.OPEN_URL, url));
    }

    protected StyleType clickableStyle(ClickEventType event) {
        return (StyleType)this.componentFactory.style().clickEvent(event).underlined();
    }

    private boolean isFileInAllowedDirectory(Path file, Path ... directories) {
        try {
            for (Path directory : directories) {
                if (!directory.toRealPath(new LinkOption[0]).equals(file.getParent().toRealPath(new LinkOption[0]))) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

