/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import gs.mclo.Constants;
import gs.mclo.MclogsCommon;
import gs.mclo.api.Util;
import gs.mclo.commands.BuildContext;
import gs.mclo.commands.Command;
import gs.mclo.commands.ICommandSourceAccessor;
import gs.mclo.commands.LogDirectory;
import gs.mclo.commands.Permission;
import gs.mclo.components.ClickEventAction;
import gs.mclo.components.IComponent;
import gs.mclo.components.IComponentFactory;
import gs.mclo.components.IStyle;
import java.nio.file.Path;

public class MclogsListCommand<ComponentType extends IComponent<ComponentType, StyleType, ClickEventType>, StyleType extends IStyle<StyleType, ClickEventType>, ClickEventType>
extends Command<ComponentType, StyleType, ClickEventType> {
    public MclogsListCommand(MclogsCommon common, IComponentFactory<ComponentType, StyleType, ClickEventType> componentFactory) {
        super(common, componentFactory);
    }

    @Override
    public <T> LiteralArgumentBuilder<T> build(BuildContext<T, ComponentType> buildContext, LiteralArgumentBuilder<T> builder) {
        LiteralArgumentBuilder list = LiteralArgumentBuilder.literal((String)"list");
        if (buildContext.environment.hasPermissions) {
            list = (LiteralArgumentBuilder)list.requires(source -> buildContext.mapSource(source).hasPermission(Permission.LIST));
        }
        list.executes(context -> this.execute(context, buildContext));
        return (LiteralArgumentBuilder)builder.then((ArgumentBuilder)list);
    }

    protected <T> int execute(CommandContext<T> context, BuildContext<T, ComponentType> buildContext) {
        ICommandSourceAccessor<ComponentType> source = buildContext.mapSource(context.getSource());
        try {
            int total = 0;
            Object message = this.componentFactory.empty();
            boolean first = true;
            for (LogDirectory logDir : source.getLogDirectories()) {
                String[] files = Util.listFilesInDirectory((Path)logDir.path());
                if (files.length > 0) {
                    if (!first) {
                        message.append("\n");
                    }
                    message.append(this.title(logDir.title()));
                    for (String log : files) {
                        message.append(this.item(log, context, buildContext));
                    }
                }
                total += files.length;
                first = false;
            }
            if (total == 0) {
                message = this.componentFactory.literal("No logs or crash reports found.");
            }
            source.sendSuccess(message, false);
            return total;
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred when listing your logs.", (Throwable)e);
            source.sendFailure(this.genericErrorMessage());
            return -1;
        }
    }

    protected ComponentType title(String title) {
        return (ComponentType)this.componentFactory.literal(title).style(this.componentFactory.style().underlined());
    }

    protected ComponentType item(String filename, CommandContext<?> context, BuildContext<?, ComponentType> buildContext) {
        String command = this.command(context, "share", filename);
        Constants.LOG.info("Command: {}", (Object)command);
        Object component = this.componentFactory.literal("\n" + filename);
        if (buildContext.supportsClientCommandClickEvents()) {
            Object clickEvent = this.componentFactory.clickEvent(ClickEventAction.RUN_COMMAND, command);
            component.style(this.componentFactory.style().clickEvent(clickEvent));
        }
        return component;
    }
}

