/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import gs.mclo.Constants;
import gs.mclo.MclogsCommon;
import gs.mclo.api.Util;
import gs.mclo.commands.BuildContext;
import gs.mclo.commands.Command;
import gs.mclo.commands.ICommandSourceAccessor;
import gs.mclo.commands.LogDirectory;
import gs.mclo.commands.Permission;
import gs.mclo.components.IComponent;
import gs.mclo.components.IComponentFactory;
import gs.mclo.components.IStyle;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;

public class MclogsShareCommand<ComponentType extends IComponent<ComponentType, StyleType, ClickEventType>, StyleType extends IStyle<StyleType, ClickEventType>, ClickEventType>
extends Command<ComponentType, StyleType, ClickEventType> {
    private static final String ARGUMENT_NAME = "filename";

    public MclogsShareCommand(MclogsCommon common, IComponentFactory<ComponentType, StyleType, ClickEventType> componentFactory) {
        super(common, componentFactory);
    }

    @Override
    public <T> LiteralArgumentBuilder<T> build(BuildContext<T, ComponentType> buildContext, LiteralArgumentBuilder<T> builder) {
        LiteralArgumentBuilder share = LiteralArgumentBuilder.literal((String)"share");
        if (buildContext.environment.hasPermissions) {
            share = (LiteralArgumentBuilder)share.requires(source -> buildContext.mapSource(source).hasPermission(Permission.SHARE_SPECIFIC));
        }
        RequiredArgumentBuilder argument = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)ARGUMENT_NAME, (ArgumentType)StringArgumentType.greedyString()).suggests((x, y) -> this.suggest(x, y, buildContext)).executes(context -> this.execute(context, buildContext));
        return (LiteralArgumentBuilder)builder.then(share.then((ArgumentBuilder)argument));
    }

    private <T> CompletableFuture<Suggestions> suggest(CommandContext<T> x, SuggestionsBuilder builder, BuildContext<T, ComponentType> buildContext) {
        ICommandSourceAccessor<ComponentType> source = buildContext.mapSource(x.getSource());
        String input = builder.getRemaining();
        try {
            for (LogDirectory dir : source.getLogDirectories()) {
                for (String file : Util.listFilesInDirectory((Path)dir.path())) {
                    if (!file.startsWith(input)) continue;
                    builder.suggest(file);
                }
            }
            return builder.buildFuture();
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred when listing your logs.", (Throwable)e);
            return Suggestions.empty();
        }
    }

    protected <T> int execute(CommandContext<T> context, BuildContext<T, ComponentType> buildContext) {
        return this.share(context, buildContext, (String)context.getArgument(ARGUMENT_NAME, String.class));
    }
}

