/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.platform;

import gs.mclo.Constants;
import gs.mclo.platform.services.IPlatformHelper;
import java.util.ServiceLoader;
import org.jetbrains.annotations.Nullable;

public class Services {
    @Nullable
    private static ClassLoader CLASS_LOADER = null;
    @Nullable
    private static IPlatformHelper PLATFORM;

    public static IPlatformHelper platform() {
        if (PLATFORM == null) {
            PLATFORM = Services.load(IPlatformHelper.class);
        }
        return PLATFORM;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        CLASS_LOADER = classLoader;
    }

    public static <T> T load(Class<T> clazz) {
        T loadedService = Services.getServiceLoader(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static <T> ServiceLoader<T> getServiceLoader(Class<T> clazz) {
        if (CLASS_LOADER == null) {
            return ServiceLoader.load(clazz);
        }
        return ServiceLoader.load(clazz, CLASS_LOADER);
    }
}

