/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.platform.services;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import gs.mclo.platform.services.IPlatformHelper;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public String getMinecraftVersion() {
        return this.getModVersion("minecraft");
    }

    @Override
    public String getModVersion() {
        return this.getModVersion("mclogs");
    }

    protected String getModVersion(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("Unknown");
    }

    @Override
    public GenericBuilder<Config, FileConfig> getConfig() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path configFile = configDir.resolve("mclogs.toml");
        return FileConfig.builder((Path)configFile);
    }
}

