/*
 * Decompiled with CFR 0.152.
 */
package gs.mclo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import gs.mclo.Constants;
import gs.mclo.commands.BuildContext;
import gs.mclo.components.IComponent;
import gs.mclo.components.IComponentFactory;
import gs.mclo.components.IStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BrigadierExecutor<T, ComponentType extends IComponent<ComponentType, StyleType, ClickEventType>, StyleType extends IStyle<StyleType, ClickEventType>, ClickEventType> {
    protected final CommandDispatcher<T> dispatcher;
    protected final BuildContext<T, ComponentType> context;
    protected final IComponentFactory<ComponentType, StyleType, ClickEventType> componentFactory;

    public BrigadierExecutor(CommandDispatcher<T> dispatcher, BuildContext<T, ComponentType> context, IComponentFactory<ComponentType, StyleType, ClickEventType> componentFactory) {
        this.dispatcher = dispatcher;
        this.context = context;
        this.componentFactory = componentFactory;
    }

    public void executeCommand(T source, String command, String[] args) {
        try {
            ParseResults<T> parse = this.parse(command, args, source);
            this.dispatcher.execute(parse);
        }
        catch (CommandSyntaxException e) {
            Object contextMessage = this.componentFactory.literal(this.exceptionContext(e)).style(this.componentFactory.style().underlined());
            Object error = this.componentFactory.literal(e.getType().toString()).append("\n").append(contextMessage).append(this.componentFactory.literal("<--[HERE]").style(this.componentFactory.style().italic()));
            this.context.mapSource(source).sendFailure(error);
        }
    }

    public List<String> completeCommand(T source, String command, String[] args) {
        ParseResults<T> parse = this.parse(command, args, source);
        try {
            Suggestions suggestions = (Suggestions)this.dispatcher.getCompletionSuggestions(parse).get(1L, TimeUnit.SECONDS);
            ArrayList<String> result = new ArrayList<String>();
            for (Suggestion suggestion : suggestions.getList()) {
                result.add(suggestion.getText());
            }
            return result;
        }
        catch (Exception e) {
            Constants.LOG.error("Failed to get tab completions", (Throwable)e);
            return List.of();
        }
    }

    protected ParseResults<T> parse(String command, String[] args, T sender) {
        Object input = command;
        if (args.length > 0) {
            input = (String)input + " " + String.join((CharSequence)" ", args);
        }
        return this.dispatcher.parse((String)input, sender);
    }

    protected String exceptionContext(CommandSyntaxException exception) {
        String input = exception.getInput();
        StringBuilder builder = new StringBuilder();
        int cursor = Math.min(input.length(), exception.getCursor());
        if (cursor > 10) {
            builder.append("...");
        }
        builder.append(input, Math.max(0, cursor - 10), cursor);
        return builder.toString();
    }
}

