/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3675;
import net.minecraft.class_7157;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiConfig;
import wiki.minecraft.heywiki.command.ImFeelingLuckyCommand;
import wiki.minecraft.heywiki.command.WhatBiomeCommand;
import wiki.minecraft.heywiki.command.WhatCommandCommand;
import wiki.minecraft.heywiki.command.WhatIsThisCommand;
import wiki.minecraft.heywiki.command.WhatIsThisItemCommand;
import wiki.minecraft.heywiki.command.WhatStructureCommand;
import wiki.minecraft.heywiki.command.WhatVersionCommand;
import wiki.minecraft.heywiki.command.WikiCommand;
import wiki.minecraft.heywiki.entrypoint.ChatWikiLinks;
import wiki.minecraft.heywiki.entrypoint.HeyWikiDebugEntry;
import wiki.minecraft.heywiki.entrypoint.Raycast;
import wiki.minecraft.heywiki.gui.screen.WikiSearchScreen;
import wiki.minecraft.heywiki.mixin.DebugScreenEntriesMixin;
import wiki.minecraft.heywiki.resource.WikiFamilyManager;
import wiki.minecraft.heywiki.resource.WikiTranslationManager;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiFamily;

public class HeyWikiClient {
    public static final String MOD_ID = "heywiki";
    public static final class_304.class_11900 HEYWIKI_CATEGORY = new class_304.class_11900(HeyWikiClient.id("heywiki"));
    public static final class_304 openWikiKey = new class_304("key.heywiki.open", class_3675.class_307.field_1668, 72, HEYWIKI_CATEGORY);
    public static final class_304 openWikiSearchKey = new class_304("key.heywiki.open_search", class_3675.class_307.field_1668, 66, HEYWIKI_CATEGORY);
    private static final Set<String> experimentsWarned = new HashSet<String>();
    private static final Set<String> deprecationsWarned = new HashSet<String>();
    private static HeyWikiClient INSTANCE;
    private final WikiFamilyManager familyManager;
    private final WikiTranslationManager translationManager;
    private final HeyWikiConfig config;

    public HeyWikiClient() {
        INSTANCE = this;
        this.config = HeyWikiConfig.load();
        KeyMappingRegistry.register((class_304)openWikiKey);
        KeyMappingRegistry.register((class_304)openWikiSearchKey);
        ClientCommandRegistrationEvent.EVENT.register(HeyWikiClient::registerCommands);
        ClientChatEvent.RECEIVED.register(ChatWikiLinks::onClientChatReceived);
        DebugScreenEntriesMixin.invokeRegister(HeyWikiClient.id("url"), new HeyWikiDebugEntry());
        ClientTooltipEvent.ITEM.register((stack, lines, tooltipContex, flag) -> {
            if (!this.config().itemTooltip()) {
                return;
            }
            if (openWikiKey.method_1415()) {
                return;
            }
            Target target = Target.of(stack);
            if (target == null) {
                return;
            }
            WikiFamily family = this.familyManager().getFamilyByNamespace(target.namespace());
            if (family == null) {
                return;
            }
            lines.add(class_2561.method_43469((String)"gui.heywiki.tooltip", (Object[])new Object[]{openWikiKey.method_16007().method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080))}).method_10862(class_2583.field_24360.method_10977(class_124.field_1063)));
        });
        ClientTickEvent.CLIENT_POST.register(Raycast::onClientTickPost);
        ClientTickEvent.CLIENT_POST.register(WikiSearchScreen::onClientTickPost);
        this.familyManager = new WikiFamilyManager();
        this.translationManager = new WikiTranslationManager();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)this.familyManager, (class_2960)HeyWikiClient.id("family"));
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)this.translationManager, (class_2960)HeyWikiClient.id("translation"), List.of(HeyWikiClient.id("family")));
    }

    private static void registerCommands(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher, class_7157 buildContext) {
        ImFeelingLuckyCommand.register(dispatcher);
        WhatBiomeCommand.register(dispatcher);
        LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> whatCommandCommand = WhatCommandCommand.register(dispatcher);
        WhatIsThisCommand.register(dispatcher);
        WhatIsThisItemCommand.register(dispatcher);
        LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> wikiCommand = WikiCommand.register(dispatcher);
        LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> whatVersionCommand = WhatVersionCommand.register(dispatcher);
        if (class_310.method_1551().method_1496()) {
            WhatStructureCommand.register(dispatcher);
        }
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatis").redirect(wikiCommand));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatcmd").redirect(whatCommandCommand));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatver").redirect(whatVersionCommand));
    }

    public HeyWikiConfig config() {
        return this.config;
    }

    public WikiFamilyManager familyManager() {
        return this.familyManager;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static HeyWikiClient getInstance() {
        return INSTANCE;
    }

    public static void experimentalWarning(Logger logger, String feature) {
        if (experimentsWarned.add(feature)) {
            logger.warn("{} is an experimental feature. It is subject to breaking changes in future minor or patch releases.", (Object)feature);
        }
    }

    public static void deprecatedWarning(Logger logger, String feature) {
        if (deprecationsWarned.add(feature)) {
            logger.warn("{} is an experimental feature. It is subject to breaking changes in future minor or patch releases.", (Object)feature);
        }
    }

    public WikiTranslationManager translationManager() {
        return this.translationManager;
    }
}

