/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.command.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.command.suggestion.NamespaceSuggestionProvider;
import wiki.minecraft.heywiki.command.suggestion.PageNameSuggestionProvider;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public class NSPageCombinedSuggestionProvider
implements SuggestionProvider<ClientCommandRegistrationEvent.ClientCommandSourceStack> {
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> context, SuggestionsBuilder builder) {
        builder.restart();
        String remaining = builder.getRemaining();
        WikiIndividual wiki = MOD.familyManager().activeWikis().get("minecraft");
        if (wiki == null) {
            return new NamespaceSuggestionProvider().getSuggestions(context, builder);
        }
        String apiUrl = wiki.mwApiUrl().orElse(null);
        if (apiUrl == null) {
            return new NamespaceSuggestionProvider().getSuggestions(context, builder);
        }
        if (!remaining.contains(":")) {
            return new PageNameSuggestionProvider(() -> URI.create(apiUrl)).getSuggestions(context, builder).thenApplyAsync(suggestions -> {
                List list = new NamespaceSuggestionProvider().getSuggestions(context, builder).join().getList();
                list.addAll(suggestions.getList());
                return new Suggestions(StringRange.at((int)builder.getStart()), list);
            });
        }
        String[] split = remaining.split(":", 2);
        if (MOD.familyManager().getAvailableNamespaces().contains(split[0])) {
            SuggestionsBuilder fakeBuilder = new SuggestionsBuilder(builder.getInput(), builder.getStart() + split[0].length() + 1);
            return new PageNameSuggestionProvider(() -> URI.create(apiUrl)).getSuggestions(context, fakeBuilder);
        }
        return new NamespaceSuggestionProvider().getSuggestions(context, builder);
    }
}

