/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.command.suggestion;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.util.CachedDebouncer;
import wiki.minecraft.heywiki.util.HttpUtil;

public class PageNameSuggestionProvider
implements SuggestionProvider<ClientCommandRegistrationEvent.ClientCommandSourceStack> {
    private static final long TIMEOUT = 400L;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final String SUGGESTION_URL = "action=opensearch&format=json&formatversion=2&limit=10&search=%s";
    private static final CachedDebouncer<String, Suggestions> debouncer = new CachedDebouncer(400L);
    private final Callable<URI> uriProvider;

    public PageNameSuggestionProvider(Callable<URI> uriProvider) {
        this.uriProvider = uriProvider;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> context, SuggestionsBuilder builder) {
        return CompletableFuture.supplyAsync(() -> {
            if (builder.getRemaining().isEmpty()) {
                return builder.build();
            }
            try {
                Optional<Suggestions> result = debouncer.get(builder.getInput(), () -> {
                    String remaining = builder.getRemaining();
                    URI uri = HttpUtil.uriWithQuery(this.uriProvider.call(), String.format(SUGGESTION_URL, HttpUtil.encodeUrl(remaining)));
                    String response = HttpUtil.request(uri);
                    JsonReader reader = GSON.newJsonReader((Reader)new StringReader(response));
                    reader.beginArray();
                    reader.skipValue();
                    reader.beginArray();
                    HashSet<String> suggestions = new HashSet<String>();
                    while (reader.hasNext()) {
                        suggestions.add(reader.nextString());
                    }
                    reader.close();
                    suggestions.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                    return builder.build();
                });
                return result.orElseGet(() -> ((SuggestionsBuilder)builder).build());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to get suggestions", (Throwable)e);
                return builder.build();
            }
        }, (Executor)class_156.method_27958());
    }
}

