/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.gui.screen;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_8019;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8208;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.gui.screen.CallbackGameMenuScreen;
import wiki.minecraft.heywiki.util.HttpUtil;
import wiki.minecraft.heywiki.wiki.PageExcerpt;
import wiki.minecraft.heywiki.wiki.WikiPage;

public class ConfirmWikiPageScreen
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_1060 textureManager = class_310.method_1551().method_1531();
    protected final BooleanConsumer callback;
    private final String link;
    private final class_2561 message;
    private final WikiPage page;
    private class_7843 layout;
    private class_2960 textureId;
    private volatile PageExcerpt excerpt;
    private volatile boolean hasExcerpt;
    private volatile byte[] image;

    public ConfirmWikiPageScreen(BooleanConsumer callback, String link, Optional<CompletableFuture<PageExcerpt>> excerpt, WikiPage page) {
        this(callback, (class_2561)class_2561.method_43471((String)"gui.heywiki_confirm_link.title"), (class_2561)class_2561.method_43470((String)URLDecoder.decode(link, StandardCharsets.UTF_8)), link, excerpt, page);
    }

    private ConfirmWikiPageScreen(BooleanConsumer callback, class_2561 title, class_2561 message, String link, Optional<CompletableFuture<PageExcerpt>> excerpt, WikiPage page) {
        super(title);
        this.layout = new class_7843(0, 0, this.field_22789, this.field_22790);
        this.textureId = class_2960.method_60655((String)"minecraft", (String)"textures/misc/unknown_server.png");
        this.hasExcerpt = false;
        this.image = null;
        this.callback = callback;
        this.message = message;
        this.link = link;
        this.page = page;
        if (excerpt.isPresent()) {
            this.hasExcerpt = true;
            this.loadImage(excerpt.get());
        }
    }

    private void loadImage(@NotNull CompletableFuture<PageExcerpt> excerpt) {
        assert (this.field_22787 != null);
        excerpt.thenAccept(result -> {
            if (result == null) {
                this.hasExcerpt = false;
                this.field_22787.execute(this::method_25426);
            }
            this.excerpt = result;
            if (this.excerpt.imageUrl() != null) {
                HttpUtil.loadAndCacheFile(this.excerpt.imageUrl()).thenAccept(image -> {
                    this.image = image;
                    this.field_22787.execute(this::method_25426);
                });
            }
            this.field_22787.execute(this::method_25426);
        });
    }

    public static void open(class_437 parent, String url, Optional<CompletableFuture<PageExcerpt>> excerpt, WikiPage page) {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new ConfirmWikiPageScreen(confirmed -> {
            if (confirmed) {
                class_156.method_668().method_670(url);
                if (client.field_1687 != null) {
                    CallbackGameMenuScreen.openWithParent(parent, true);
                }
            } else {
                client.method_1507(parent);
            }
        }, url, excerpt, page));
    }

    public class_2561 method_25435() {
        return class_5244.method_37110((class_2561[])new class_2561[]{super.method_25435(), this.message});
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == 257 || HeyWikiClient.openWikiKey.method_1417(keyEvent)) {
            this.callback.accept(true);
            return true;
        }
        if (keyEvent.comp_4795() == 67 && keyEvent.method_74240() && !keyEvent.method_74239() && !keyEvent.method_74238()) {
            this.callback.accept(false);
            this.copyToClipboard();
            return false;
        }
        if (keyEvent.comp_4795() == 256) {
            this.callback.accept(false);
            return true;
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25419() {
        if (!this.textureId.equals((Object)class_2960.method_60655((String)"minecraft", (String)"textures/misc/unknown_server.png"))) {
            textureManager.method_4615(this.textureId);
        }
        super.method_25419();
    }

    protected synchronized void method_25426() {
        super.method_25426();
        this.layout = new class_7843(0, 0, this.field_22789, this.field_22790);
        this.method_37067();
        class_8667 mainLayout = (class_8667)this.layout.method_46441((class_8021)class_8667.method_52741().method_52735(10));
        mainLayout.method_52740().method_46467();
        class_5250 pageTitle = class_2561.method_43470((String)(this.excerpt != null ? this.excerpt.title() : this.page.pageName())).method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)));
        if (!this.hasExcerpt) {
            mainLayout.method_52736((class_8021)new class_7842((class_2561)pageTitle, this.field_22793));
            ((class_8019)mainLayout.method_52738((class_8021)new class_8019(this.field_22789, (class_2561)this.message.method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_30938(Boolean.valueOf(true))), this.field_22793, false, class_8019.class_11763.field_62117, 3), positioner -> positioner.method_46479(3))).method_48981(false);
        } else {
            class_8667 excerptLayout = (class_8667)mainLayout.method_52736((class_8021)class_8667.method_52742().method_52735(8));
            class_8208 iconWidget = this.createImageWidget();
            int imageWidth = iconWidget.method_25368();
            excerptLayout.method_52738((class_8021)iconWidget, positioner -> positioner.method_46464(5));
            class_8667 excerptTextLayout = (class_8667)excerptLayout.method_52736((class_8021)class_8667.method_52741().method_52735(8));
            excerptTextLayout.method_52736((class_8021)new class_7842((class_2561)pageTitle, this.field_22793));
            ((class_8019)excerptTextLayout.method_52736((class_8021)new class_8019(this.field_22789, (class_2561)this.message.method_27661().method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_30938(Boolean.valueOf(true))), this.field_22793, false, class_8019.class_11763.field_62119, 3))).method_48981(false);
            ((class_8019)excerptTextLayout.method_52738((class_8021)new class_8019(this.field_22789 - 65 - (imageWidth + 13), (class_2561)(this.excerpt != null ? class_2561.method_43470((String)this.excerpt.excerpt().replace("\u200b", "")) : class_2561.method_43471((String)"gui.heywiki_confirm_link.loading_excerpt")), this.field_22793, 5), positioner -> positioner.method_46464(5))).method_48981(false);
        }
        class_8667 buttonLayout = (class_8667)mainLayout.method_52736((class_8021)class_8667.method_52741().method_52735(8));
        buttonLayout.method_52740().method_46467();
        buttonLayout.method_52738((class_8021)this.createButtonLayout(), positioner -> positioner.method_46475(20));
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    private class_8208 createImageWidget() {
        int height = 100;
        int realWidth = this.excerpt != null ? this.excerpt.imageWidth() : 0;
        int realHeight = this.excerpt != null ? this.excerpt.imageHeight() : 0;
        double aspectRatio = (double)realWidth / (double)realHeight;
        int maxWidth = 200;
        int width = (int)((double)height * aspectRatio);
        int newWidth = -1;
        if (width > 200) {
            width = 200;
            newWidth = realHeight * (200 / height);
        }
        assert (this.field_22787 != null);
        if (this.image != null) {
            try {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(this.image));
                if (newWidth != -1) {
                    int x = (realWidth - newWidth) / 2;
                    image = image.getSubimage(x, 0, newWidth, realHeight);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "png", os);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                this.textureId = HeyWikiClient.id(String.valueOf(this.link.hashCode()));
                class_1043 texture = new class_1043(() -> this.textureId.toString(), class_1011.method_4309((InputStream)is));
                textureManager.method_4616(this.textureId, (class_1044)texture);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load image", (Throwable)e);
            }
        }
        return class_8208.method_52721((int)width, (int)height, (class_2960)this.textureId, (int)width, (int)height);
    }

    protected class_8667 createButtonLayout() {
        class_8667 layout = class_8667.method_52742().method_52735(8);
        layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"chat.link.open"), button -> this.callback.accept(true)).method_46432(100).method_46431());
        layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"chat.copy"), button -> {
            this.copyToClipboard();
            this.callback.accept(false);
        }).method_46432(100).method_46431());
        layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.callback.accept(false)).method_46432(100).method_46431());
        return layout;
    }

    public void copyToClipboard() {
        assert (this.field_22787 != null);
        this.field_22787.field_1774.method_1455(this.link);
    }

    protected void method_48640() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }
}

