/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.mixin;

import com.google.common.collect.Ordering;
import dev.architectury.platform.Platform;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_1293;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_492;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.extension.AbstractContainerScreenInterface;
import wiki.minecraft.heywiki.extension.MerchantScreenInterface;
import wiki.minecraft.heywiki.mixin.ScreenMixin;
import wiki.minecraft.heywiki.target.Target;
import wiki.minecraft.heywiki.wiki.WikiPage;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin
extends ScreenMixin
implements AbstractContainerScreenInterface {
    @Shadow
    @Nullable
    protected class_1735 field_2787;
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    protected int field_2792;
    @Unique
    private int heywiki$mouseX;
    @Unique
    private int heywiki$mouseY;
    @Unique
    private boolean heywiki$hasStatusEffect = false;

    @Inject(method={"method_25394(Lnet/minecraft/class_332;IIF)V"}, at={@At(value="HEAD")})
    public void render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo cir) {
        this.heywiki$mouseX = mouseX;
        this.heywiki$mouseY = mouseY;
    }

    @Inject(method={"method_25404(Lnet/minecraft/class_11908;)Z"}, at={@At(value="HEAD")})
    public void keyPressed(class_11908 keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (!HeyWikiClient.openWikiKey.method_1417(keyEvent)) {
            return;
        }
        if (!this.heywiki$tryFocusedSlot()) {
            this.heywiki$tryStatusEffect();
        }
    }

    @Unique
    private boolean heywiki$tryFocusedSlot() {
        class_1735 slot = this.field_2787;
        class_1799 stack = null;
        if (slot != null && slot.method_7681()) {
            stack = slot.method_7677();
        } else {
            class_465 class_4652 = (class_465)this;
            if (class_4652 instanceof class_492) {
                class_492 that = (class_492)class_4652;
                stack = ((MerchantScreenInterface)that).heywiki$getHoveredStack();
            }
        }
        if (stack == null) {
            return false;
        }
        Target target = Target.of(stack);
        if (target != null) {
            WikiPage page = WikiPage.fromTarget(target);
            if (page == null) {
                class_310.method_1551().field_1705.method_1758(WikiPage.NO_FAMILY_MESSAGE, false);
                return false;
            }
            page.openInBrowser(class_310.method_1551().field_1755);
            return true;
        }
        return false;
    }

    @Unique
    private boolean heywiki$tryStatusEffect() {
        if (Platform.isModLoaded((String)"emi") || !this.heywiki$hasStatusEffect) {
            return false;
        }
        class_310 client = class_310.method_1551();
        assert (client != null);
        int effectX = this.field_2776 + this.field_2792 + 2;
        int availableWidth = this.field_22789 - effectX;
        assert (client.field_1724 != null);
        Collection effectInstances = client.field_1724.method_6026();
        List effectInstancesSorted = Ordering.natural().sortedCopy((Iterable)effectInstances);
        int effectWidth = 33;
        if (availableWidth >= 120) {
            effectWidth = 121;
        }
        int effectHeight = 33;
        if (effectInstances.size() > 5) {
            effectHeight = 132 / (effectInstances.size() - 1);
        }
        if (availableWidth > 32 && this.heywiki$mouseX >= effectX && this.heywiki$mouseX <= effectX + effectWidth) {
            int effectY = this.field_2800;
            class_1293 effectFound = null;
            for (class_1293 effect : effectInstancesSorted) {
                if (this.heywiki$mouseY >= effectY && this.heywiki$mouseY <= effectY + effectHeight) {
                    effectFound = effect;
                }
                effectY += effectHeight;
            }
            if (effectFound != null) {
                Target target = Target.of(effectFound);
                assert (target != null);
                WikiPage page = WikiPage.fromTarget(target);
                if (page == null) {
                    client.field_1705.method_1758(WikiPage.NO_FAMILY_MESSAGE, false);
                    return false;
                }
                page.openInBrowser(class_310.method_1551().field_1755);
                return true;
            }
        }
        return false;
    }

    @Override
    @Unique
    public void heywiki$setHasStatusEffect() {
        this.heywiki$hasStatusEffect = true;
    }
}

