/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CachedDebouncer<Key, Value> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final long timeoutMillis;
    private final Cache<Key, Value> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private volatile Key lastInput;

    public CachedDebouncer(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public Optional<Value> get(Key key, Callable<Value> provider) throws ExecutionException {
        this.lastInput = key;
        Object value = this.cache.getIfPresent(key);
        if (value != null) {
            return Optional.of(value);
        }
        try {
            Thread.sleep(this.timeoutMillis);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for debounce", (Throwable)e);
        }
        if (!key.equals(this.lastInput)) {
            return Optional.empty();
        }
        return Optional.of(this.cache.get(key, provider));
    }
}

