/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.util;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class HttpUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    public static String request(URI uri) throws IOException, InterruptedException {
        return HttpUtil.request(uri, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
    }

    @NotNull
    public static <T> T request(URI uri, HttpResponse.BodyHandler<T> handler) throws IOException, InterruptedException {
        try (HttpClient client = HttpClient.newBuilder().proxy(ProxySelector.getDefault()).followRedirects(HttpClient.Redirect.ALWAYS).build();){
            HttpRequest request = HttpRequest.newBuilder(uri).GET().header("User-Agent", "HeyWikiMod (+https://github.com/mc-wiki/minecraft-mod-heywiki)").build();
            HttpResponse<T> response = client.send(request, handler);
            if (response.statusCode() != 200) {
                throw new IOException("HTTP " + response.statusCode() + " " + String.valueOf(response.body()));
            }
            T t = response.body();
            return t;
        }
    }

    public static URI uriWithQuery(URI uri, String query) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static URI uriWithPath(URI uri, String path) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CompletableFuture<byte[]> loadAndCacheFile(String url) {
        return CompletableFuture.supplyAsync(() -> {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            String hash = Hex.encodeHexString((byte[])md.digest(url.getBytes(StandardCharsets.UTF_8)));
            String tempDir = System.getProperty("java.io.tmpdir");
            Path path = FileSystems.getDefault().getPath(tempDir, "/heywiki/", hash);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    return Files.readAllBytes(path);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to fetch file", (Throwable)e);
                }
            } else {
                try {
                    byte[] fileData = HttpUtil.request(URI.create(url), HttpResponse.BodyHandlers.ofByteArray());
                    Path parentDir = path.getParent();
                    if (!Files.exists(parentDir, new LinkOption[0])) {
                        Files.createDirectories(parentDir, new FileAttribute[0]);
                    }
                    Files.write(path, fileData, new OpenOption[0]);
                    return fileData;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to fetch image", (Throwable)e);
                }
            }
            return null;
        }, (Executor)class_156.method_55473());
    }

    public static String encodeUrl(String url) {
        return URLEncoder.encode(url, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
    }
}

