/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki.wiki;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wiki.minecraft.heywiki.HeyWikiClient;
import wiki.minecraft.heywiki.wiki.WikiIndividual;

public record WikiFamily(List<String> namespace, List<WikiIndividual> wikis) implements Comparable<WikiFamily>
{
    public static final Codec<WikiFamily> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.listOf().fieldOf("namespace").forGetter(family -> family.namespace), (App)WikiIndividual.CODEC.listOf().fieldOf("wikis").forGetter(family -> family.wikis)).apply((Applicative)builder, WikiFamily::new));
    private static final HeyWikiClient MOD = HeyWikiClient.getInstance();

    public WikiIndividual getWiki() {
        WikiIndividual wiki;
        if (MOD.config().language().equals("auto")) {
            String language = class_310.method_1551().field_1690.field_1883;
            wiki = this.getLanguageWikiByGameLanguage(language);
        } else {
            String language = MOD.config().language();
            wiki = this.getLanguageWikiByWikiLanguage(language);
        }
        if (wiki == null) {
            wiki = this.getMainLanguageWiki();
        }
        return wiki;
    }

    @Nullable
    public WikiIndividual getLanguageWikiByGameLanguage(String gameLanguage) {
        for (WikiIndividual wiki : this.wikis) {
            if (!wiki.language().match(gameLanguage).booleanValue()) continue;
            return wiki;
        }
        return null;
    }

    @Nullable
    public WikiIndividual getLanguageWikiByWikiLanguage(String wikiLanguage) {
        for (WikiIndividual wiki : this.wikis) {
            if (!wiki.language().wikiLanguage().equals(wikiLanguage)) continue;
            return wiki;
        }
        return null;
    }

    public WikiIndividual getMainLanguageWiki() {
        for (WikiIndividual wiki : this.wikis) {
            if (!wiki.language().main().booleanValue()) continue;
            return wiki;
        }
        throw new RuntimeException("Failed to find main language wiki for family " + String.valueOf(this.id()));
    }

    public class_2960 id() {
        return MOD.familyManager().getFamilyId(this);
    }

    public String getTranslationKey() {
        return class_156.method_646((String)"wiki_family", (class_2960)this.id());
    }

    @Override
    public int compareTo(@NotNull WikiFamily o) {
        return this.id().method_12833(o.id());
    }
}

