/*
 * Decompiled with CFR 0.152.
 */
package wiki.minecraft.heywiki;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3675;
import net.minecraft.class_7157;
import org.slf4j.Logger;
import wiki.minecraft.heywiki.HeyWikiConfig;
import wiki.minecraft.heywiki.command.ImFeelingLuckyCommand;
import wiki.minecraft.heywiki.command.WhatBiomeCommand;
import wiki.minecraft.heywiki.command.WhatCommandCommand;
import wiki.minecraft.heywiki.command.WhatIsThisCommand;
import wiki.minecraft.heywiki.command.WhatIsThisItemCommand;
import wiki.minecraft.heywiki.command.WhatStructureCommand;
import wiki.minecraft.heywiki.command.WikiCommand;
import wiki.minecraft.heywiki.entrypoint.ChatWikiLinks;
import wiki.minecraft.heywiki.entrypoint.Raycast;
import wiki.minecraft.heywiki.gui.screen.WikiSearchScreen;
import wiki.minecraft.heywiki.resource.WikiFamilyManager;
import wiki.minecraft.heywiki.resource.WikiTranslationManager;

public class HeyWikiClient {
    public static final String MOD_ID = "heywiki";
    private static final class_310 client = class_310.method_1551();
    public static final class_304 openWikiKey = new class_304("key.heywiki.open", class_3675.class_307.field_1668, 72, "key.categories.heywiki");
    public static final class_304 openWikiSearchKey = new class_304("key.heywiki.open_search", class_3675.class_307.field_1668, 66, "key.categories.heywiki");
    private static HeyWikiClient INSTANCE;
    private final WikiFamilyManager familyManager;
    private final WikiTranslationManager translationManager;
    private final HeyWikiConfig config;
    private static final Set<String> experimentsWarned;
    private static final Set<String> deprecationsWarned;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public HeyWikiClient() {
        INSTANCE = this;
        this.config = HeyWikiConfig.load();
        KeyMappingRegistry.register((class_304)openWikiKey);
        KeyMappingRegistry.register((class_304)openWikiSearchKey);
        ClientCommandRegistrationEvent.EVENT.register(HeyWikiClient::registerCommands);
        ClientChatEvent.RECEIVED.register(ChatWikiLinks::onClientChatReceived);
        ClientGuiEvent.DEBUG_TEXT_RIGHT.register(Raycast::onDebugTextRight);
        ClientTickEvent.CLIENT_POST.register(Raycast::onClientTickPost);
        ClientTickEvent.CLIENT_POST.register(WikiSearchScreen::onClientTickPost);
        this.familyManager = new WikiFamilyManager();
        this.translationManager = new WikiTranslationManager();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)this.familyManager, (class_2960)HeyWikiClient.id("family"));
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)this.translationManager, (class_2960)HeyWikiClient.id("translation"), List.of(HeyWikiClient.id("family")));
    }

    private static void registerCommands(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher, class_7157 registryAccess) {
        ImFeelingLuckyCommand.register(dispatcher);
        WhatBiomeCommand.register(dispatcher);
        LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> whatCommandCommand = WhatCommandCommand.register(dispatcher);
        WhatIsThisCommand.register(dispatcher);
        WhatIsThisItemCommand.register(dispatcher);
        LiteralCommandNode<ClientCommandRegistrationEvent.ClientCommandSourceStack> wikiCommand = WikiCommand.register(dispatcher);
        if (client.method_1496()) {
            WhatStructureCommand.register(dispatcher);
        }
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatis").redirect(wikiCommand));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"whatcmd").redirect(whatCommandCommand));
    }

    public static HeyWikiClient getInstance() {
        return INSTANCE;
    }

    public static void experimentalWarning(Logger logger, String feature) {
        if (experimentsWarned.add(feature)) {
            logger.warn("{} is an experimental feature. It is subject to breaking changes in future minor or patch releases.", (Object)feature);
        }
    }

    public static void deprecatedWarning(Logger logger, String feature) {
        if (deprecationsWarned.add(feature)) {
            logger.warn("{} is an experimental feature. It is subject to breaking changes in future minor or patch releases.", (Object)feature);
        }
    }

    public WikiFamilyManager familyManager() {
        return this.familyManager;
    }

    public WikiTranslationManager translationManager() {
        return this.translationManager;
    }

    public HeyWikiConfig config() {
        return this.config;
    }

    static {
        experimentsWarned = new HashSet<String>();
        deprecationsWarned = new HashSet<String>();
    }
}

